/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.openservo.feedback;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jflux.api.core.Source;
import org.jflux.impl.services.rk.osgi.OSGiUtils;
import org.jflux.impl.services.rk.osgi.SingleServiceListener;
import org.mechio.api.motion.servos.ServoController;
import org.mechio.impl.motion.dynamixel.DynamixelController;
import org.mechio.impl.motion.dynamixel.feedback.DynamixelControlLoop;
import org.mechio.impl.motion.openservo.feedback.OpenServoControlLoop;
import org.mechio.impl.motion.rxtx.serial.RXTXSerialPort;
import org.osgi.framework.BundleContext;

public class DynamixelTracker
implements Source<RXTXSerialPort> {
    private SingleServiceListener<ServoController> myTracker;

    public DynamixelTracker(final OpenServoControlLoop osLoop) {
        BundleContext context = OSGiUtils.getBundleContext(ServoController.class);
        this.myTracker = new SingleServiceListener(ServoController.class, context, OSGiUtils.createFilter((String)"servoControllerVersion", (String)DynamixelController.VERSION.toString()));
        this.myTracker.addPropertyChangeListener("serviceTracked", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DynamixelController controller = (DynamixelController)((Object)evt.getNewValue());
                if (controller == null) {
                    throw new IllegalArgumentException();
                }
                DynamixelControlLoop loop = controller.getControlLoop();
                if (loop == null) {
                    throw new IllegalArgumentException();
                }
                loop.setOpenServoLoop(osLoop);
            }
        });
        this.myTracker.start();
    }

    public RXTXSerialPort getValue() {
        if (this.myTracker == null) {
            return null;
        }
        DynamixelController c = (DynamixelController)((Object)this.myTracker.getService());
        if (c == null) {
            return null;
        }
        return c.getPort();
    }
}

