/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.pololu;

import java.util.Arrays;
import java.util.List;
import org.jflux.api.common.rk.position.NormalizableRange;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.jflux.api.common.rk.property.PropertyChangeNotifier;
import org.mechio.api.motion.JointProperty;
import org.mechio.api.motion.servos.utils.AbstractServoJointAdapter;
import org.mechio.impl.motion.pololu.MaestroServo;

public class MaestroJointAdapter
extends AbstractServoJointAdapter<MaestroServo> {
    protected List<JointProperty> getJointProperties(MaestroServo s) {
        return Arrays.asList(new JointProperty[]{new MaestroPosition(s)});
    }

    public static class MaestroPosition
    extends PropertyChangeNotifier
    implements JointProperty<NormalizedDouble> {
        private MaestroServo myServo;
        private NormalizableRange myRange;

        public MaestroPosition(MaestroServo servo) {
            if (servo == null) {
                throw new NullPointerException();
            }
            this.myServo = servo;
            this.myRange = new NormalizableRange.DefaultRange();
        }

        public String getPropertyName() {
            return "currentPosition";
        }

        public String getDisplayName() {
            return "currentPosition";
        }

        public Class<NormalizedDouble> getPropertyClass() {
            return NormalizedDouble.class;
        }

        public boolean getWriteable() {
            return false;
        }

        public NormalizedDouble getValue() {
            return this.myServo.getGoalPosition();
        }

        public void setValue(NormalizedDouble val) {
        }

        public NormalizableRange<NormalizedDouble> getNormalizableRange() {
            return this.myRange;
        }
    }
}

