/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.pololu;

import java.util.ArrayList;
import java.util.List;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.mechio.impl.motion.pololu.MaestroServo;

public class MaestroSuspendLoop {
    public static final int DEFAULT_LOOP_INTERVAL = 5000;
    public static final int DEFAULT_TIMEOUT = 5000;
    private int myLoopInterval;
    private boolean myRunFlag;
    private List<AutoDisableConfig> myDisableConfigs = new ArrayList<AutoDisableConfig>();

    public MaestroSuspendLoop(int loopInterval) {
        this.myLoopInterval = Math.max(loopInterval, 1);
        this.myRunFlag = false;
    }

    public void addServo(MaestroServo servo, int timeoutLength) {
        if (servo == null) {
            return;
        }
        AutoDisableConfig c = new AutoDisableConfig();
        c.myServo = servo;
        c.myDisableTimeoutLength = Math.max(timeoutLength, 1);
        this.myDisableConfigs.add(c);
    }

    public synchronized void startLoop() {
        if (this.myRunFlag) {
            return;
        }
        this.myRunFlag = true;
        new Thread(new LoopWorker()).start();
    }

    public synchronized void stopLoop() {
        this.myRunFlag = false;
    }

    public void checkAndSuspend() {
        for (AutoDisableConfig c : this.myDisableConfigs) {
            long changeTimestamp = c.myServo.getLastGoalChangeTime();
            long elapsed = TimeUtils.now() - changeTimestamp;
            if (elapsed <= (long)c.myDisableTimeoutLength) continue;
            c.myServo.setSuspended(true);
        }
    }

    class AutoDisableConfig {
        public MaestroServo myServo;
        public int myDisableTimeoutLength;

        AutoDisableConfig() {
        }
    }

    class LoopWorker
    implements Runnable {
        LoopWorker() {
        }

        @Override
        public void run() {
            while (MaestroSuspendLoop.this.myRunFlag) {
                MaestroSuspendLoop.this.checkAndSuspend();
                TimeUtils.sleep((long)MaestroSuspendLoop.this.myLoopInterval);
            }
        }
    }
}

