/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.pololu;

import org.jflux.api.common.rk.position.BooleanRange;
import org.jflux.api.common.rk.position.NormalizableRange;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.impl.services.rk.utils.HashCodeUtil;
import org.jflux.impl.services.rk.utils.LocalIdentifier;
import org.mechio.api.motion.joint_properties.EnableMovement;
import org.mechio.api.motion.joint_properties.EnableTorque;
import org.mechio.api.motion.joint_properties.ReadCurrentPosition;
import org.mechio.api.motion.servos.AbstractServo;
import org.mechio.api.motion.servos.ServoController;
import org.mechio.api.motion.servos.config.ServoConfig;
import org.mechio.impl.motion.pololu.MaestroController;

public class MaestroServo
extends AbstractServo<Id, ServoConfig<Id>, MaestroController> {
    private Id myPhysicalId = (Id)this.myConfig.getServoId();
    private Boolean myEnabledFlag = true;
    private int myMinPosition;
    private int myMaxPosition;
    private NormalizedDouble myDefaultPosition;
    private String myName;
    private boolean mySuspendedFlag;
    private long myLastGoalChangeTimestamp;

    protected MaestroServo(ServoConfig<Id> params, MaestroController controller) {
        super(params, (ServoController)controller);
        this.myMinPosition = params.getMinPosition();
        this.myMaxPosition = params.getMaxPosition();
        double defInt = params.getDefaultPosition() - this.myMinPosition;
        double range = this.myMaxPosition - this.myMinPosition;
        double val = defInt / range;
        if (!NormalizedDouble.isValid((double)val)) {
            throw new IllegalArgumentException("Default Position invalid: " + params.getDefaultPosition());
        }
        this.myDefaultPosition = new NormalizedDouble(val);
        this.myName = params.getName();
        this.myGoalPosition = this.myDefaultPosition;
        this.myLastGoalChangeTimestamp = TimeUtils.now();
        this.mySuspendedFlag = false;
    }

    public Id getPhysicalId() {
        return this.myPhysicalId;
    }

    public void setGoalPosition(NormalizedDouble pos) {
        NormalizedDouble oldPos = this.myGoalPosition;
        super.setGoalPosition(pos);
        if (pos != oldPos) {
            this.myLastGoalChangeTimestamp = TimeUtils.now();
            this.setSuspended(false);
        }
    }

    public long getLastGoalChangeTime() {
        return this.myLastGoalChangeTimestamp;
    }

    public synchronized void setSuspended(boolean val) {
        if (this.mySuspendedFlag == val) {
            return;
        }
        this.mySuspendedFlag = val;
        if (val) {
            ((MaestroController)this.myController).disableServoPWM(this.getPhysicalId());
        } else if (!this.getEnabled().booleanValue()) {
            ((MaestroController)this.myController).enableServoPWM(this.getPhysicalId());
        }
    }

    public void setEnabled(Boolean enabled) {
        Boolean old = this.myEnabledFlag;
        this.myEnabledFlag = enabled;
        if (enabled.booleanValue()) {
            ((MaestroController)this.myController).enableServoPWM(this.getPhysicalId());
        } else {
            ((MaestroController)this.myController).disableServoPWM(this.getPhysicalId());
        }
        this.firePropertyChange("enabled", old, enabled);
    }

    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public String getName() {
        return this.myName;
    }

    public int getMinPosition() {
        return this.myMinPosition;
    }

    public int getMaxPosition() {
        return this.myMaxPosition;
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myDefaultPosition;
    }

    class MaestroTorque
    extends EnableTorque {
        MaestroTorque() {
        }

        public Boolean getValue() {
            return MaestroServo.this.getEnabled();
        }

        public void setValue(Boolean val) {
            MaestroServo.this.setEnabled(val);
        }

        public NormalizableRange<Boolean> getNormalizableRange() {
            return BooleanRange.DEFAULT_RANGE;
        }

        public boolean getWriteable() {
            return true;
        }
    }

    class MaestroEnabled
    extends EnableMovement {
        MaestroEnabled() {
        }

        public Boolean getValue() {
            return MaestroServo.this.getEnabled();
        }

        public void setValue(Boolean val) {
            MaestroServo.this.setEnabled(val);
        }

        public NormalizableRange<Boolean> getNormalizableRange() {
            return BooleanRange.DEFAULT_RANGE;
        }

        public boolean getWriteable() {
            return true;
        }
    }

    class MaestroCurrentPosition
    extends ReadCurrentPosition {
        MaestroCurrentPosition() {
        }

        public NormalizedDouble getValue() {
            return MaestroServo.this.getGoalPosition();
        }

        public NormalizableRange<NormalizedDouble> getNormalizableRange() {
            return NormalizableRange.NORMALIZED_RANGE;
        }
    }

    public static final class Id
    implements LocalIdentifier,
    Comparable {
        private static final int theIdCount = 12;
        private byte myServoNumber;

        public Id(byte num) {
            if (!Id.isValidId(num)) {
                throw new IllegalArgumentException("PhysicalId out of range.");
            }
            this.myServoNumber = num;
        }

        final byte getServoNumber() {
            return this.myServoNumber;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.myServoNumber == ((Id)obj).myServoNumber;
        }

        boolean isConsecutive(Id id) {
            return id != null && this.myServoNumber + 1 == id.myServoNumber;
        }

        Id getOffsetId(byte offset) {
            int id = this.myServoNumber + offset;
            if (!Id.isValidId(id)) {
                return null;
            }
            return new Id((byte)id);
        }

        public static boolean isValidId(int id) {
            return id >= 0 && id < 12;
        }

        public int hashCode() {
            return HashCodeUtil.hash((int)23, (int)this.myServoNumber);
        }

        public String toString() {
            return "" + this.myServoNumber;
        }

        public int compareTo(Object o) {
            Byte b;
            if (o == null || !Id.class.isAssignableFrom(o.getClass())) {
                return 1;
            }
            Byte a = this.myServoNumber;
            int compare = a.compareTo(b = Byte.valueOf(((Id)o).myServoNumber));
            if (compare == 0 && o.getClass() != this.getClass()) {
                return 1;
            }
            return compare;
        }
    }
}

