/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.rxtx.serial;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.property.PropertyChangeAction;
import org.jflux.api.common.rk.property.PropertyChangeActionBase;
import org.mechio.api.motion.servos.AbstractServoController;
import org.mechio.api.motion.servos.Servo;
import org.mechio.api.motion.servos.config.ServoConfig;
import org.mechio.api.motion.servos.utils.ConnectionStatus;
import org.mechio.impl.motion.rxtx.serial.RXTXSerialPort;
import org.mechio.impl.motion.serial.BaudRate;
import org.mechio.impl.motion.serial.SerialServoControllerConfig;

public abstract class SerialServoController<Id, ServoConf extends ServoConfig<Id>, S extends Servo<Id, ServoConf>, ControllerConf extends SerialServoControllerConfig<Id, ServoConf>>
extends AbstractServoController<Id, ServoConf, S, ControllerConf> {
    private static final Logger theLogger = Logger.getLogger(SerialServoController.class.getName());
    protected RXTXSerialPort myPort;
    protected int myTimeoutLength;

    public SerialServoController(ControllerConf config) {
        super(config);
        this.myChangeMonitor.addAction("errorMessages", (PropertyChangeActionBase)new PropertyChangeAction(){

            protected void run(PropertyChangeEvent event) {
                SerialServoController.this.firePropertyChange("errorMessages", null, event.getNewValue());
            }
        });
        this.myTimeoutLength = 100;
    }

    public void setTimeoutLength(int timeout) {
        this.myTimeoutLength = timeout;
        if (this.myPort == null) {
            return;
        }
        this.myPort.setTimeoutLength(timeout);
    }

    public boolean connect() {
        if (ConnectionStatus.DISCONNECTED != this.myConnectionStatus) {
            theLogger.log(Level.WARNING, "Error: Port must be disconnected before connecting.");
            return false;
        }
        if (this.myConfig == null) {
            theLogger.log(Level.WARNING, "Unnable to connect to Serial Port, null Config.");
            return false;
        }
        String portName = ((SerialServoControllerConfig)this.myConfig).getPortName();
        if (portName == null) {
            theLogger.log(Level.WARNING, "Unable to connect to Serial Port, no Port Name.");
            return false;
        }
        BaudRate baudRate = ((SerialServoControllerConfig)this.myConfig).getBaudRate();
        if (baudRate == null) {
            theLogger.log(Level.WARNING, "Unable to connect to Serial Port, no Baud Rate.");
            return false;
        }
        int rate = baudRate.getInt();
        this.myPort = new RXTXSerialPort(portName);
        this.myPort.setTimeoutLength(this.myTimeoutLength);
        this.myPort.addPropertyChangeListener((PropertyChangeListener)this.myChangeMonitor);
        boolean ret = this.myPort.connect(rate, 8, 1, 0);
        if (!ret) {
            return false;
        }
        return this.setStatusAndReturn(ret, ConnectionStatus.CONNECTED);
    }

    protected abstract boolean setServos();

    public boolean disconnect() {
        if (ConnectionStatus.DISCONNECTED == this.myConnectionStatus) {
            return true;
        }
        boolean ret = this.myPort.disconnect();
        return this.setStatusAndReturn(ret, ConnectionStatus.DISCONNECTED);
    }

    private boolean setStatusAndReturn(boolean ret, ConnectionStatus status) {
        if (status == null) {
            return false;
        }
        if (!ret || status != this.myPort.getConnectionStatus()) {
            return false;
        }
        ConnectionStatus oldStatus = this.myConnectionStatus;
        this.myConnectionStatus = status;
        this.firePropertyChange("connectionStatus", oldStatus, status);
        return ret;
    }

    public List<String> getErrorMessages() {
        if (this.myPort == null) {
            return null;
        }
        return this.myPort.getErrors();
    }
}

