/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.rxtx.serial;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.property.PropertyChangeNotifier;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.mechio.api.motion.servos.utils.ConnectionStatus;

public class RXTXSerialPort
extends PropertyChangeNotifier {
    private static final Logger theLogger = Logger.getLogger(RXTXSerialPort.class.getName());
    public static final String PROP_ERRORS = "Errors";
    public static final String TIMEOUT_ERROR = "Operation Timed Out";
    public static final String PORT_NOT_FOUND_ERROR = "Port Not Found";
    public static final String PORT_IN_USE_ERROR = "Port in Use";
    public static final String INVALID_PORT_ERROR = "Not a Valid Serial Port";
    public static final String READ_ERROR = "Port Read Error";
    public static final String WRITE_ERROR = "Port Write Error";
    public static final String DEVICE_ERROR = "Device Error";
    private SerialPort myPort;
    private OutputStream myPortWriter;
    private InputStream myPortReader;
    private String myPortName;
    private ConnectionStatus myConnectionStatus;
    private ConnectionStatus myPreviousStatus;
    private List<String> myErrors;
    private int myTimeoutLength;
    private int myBaudRate;
    private int myDataBtis;
    private int myStopBits;
    private int myParity;

    public RXTXSerialPort(String portName) {
        this.myPortName = portName;
        this.myConnectionStatus = ConnectionStatus.DISCONNECTED;
        this.myPreviousStatus = ConnectionStatus.DISCONNECTED;
        this.myTimeoutLength = 100;
        this.myErrors = new ArrayList<String>();
    }

    public synchronized void setTimeoutLength(int len) {
        this.myTimeoutLength = len;
        if (ConnectionStatus.DISCONNECTED == this.myConnectionStatus) {
            return;
        }
        try {
            this.myPort.enableReceiveTimeout(this.myTimeoutLength);
        }
        catch (UnsupportedCommOperationException ex) {
            theLogger.log(Level.WARNING, "Unable to set port timeout length.", ex);
        }
    }

    public int getTimeoutLength() {
        return this.myTimeoutLength;
    }

    public SerialPort getPort() {
        return this.myPort;
    }

    public OutputStream getWriter() {
        return this.myPortWriter;
    }

    public InputStream getReader() {
        return this.myPortReader;
    }

    public synchronized boolean connect(int baudRate, int dataBtis, int stopBits, int parity) {
        if (ConnectionStatus.DISCONNECTED != this.myConnectionStatus) {
            theLogger.log(Level.WARNING, "Error: Port must be disconnected before connecting.");
            return false;
        }
        CommPort commPort = null;
        try {
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(this.myPortName);
            commPort = portIdentifier.open(((Object)((Object)this)).getClass().getName(), 1000);
            if (!(commPort instanceof SerialPort)) {
                this.addError(INVALID_PORT_ERROR);
                return false;
            }
            this.myPort = (SerialPort)commPort;
            this.myPort.setSerialPortParams(baudRate, dataBtis, stopBits, parity);
            this.myPortReader = this.myPort.getInputStream();
            this.myPortWriter = this.myPort.getOutputStream();
            this.myConnectionStatus = ConnectionStatus.CONNECTED;
            this.myPort.enableReceiveTimeout(this.myTimeoutLength);
            return true;
        }
        catch (NoSuchPortException ex) {
            this.addError(PORT_NOT_FOUND_ERROR, ex);
        }
        catch (PortInUseException ex) {
            this.addError(PORT_IN_USE_ERROR, ex);
        }
        catch (UnsupportedCommOperationException ex) {
            this.addError(DEVICE_ERROR, ex);
        }
        catch (IOException ex) {
            this.addError(DEVICE_ERROR, ex);
        }
        catch (Throwable t) {
            this.addError(DEVICE_ERROR, t);
        }
        this.cleanup();
        return false;
    }

    private void cleanup() {
        try {
            if (this.myPortReader != null) {
                this.myPortReader.close();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (this.myPortWriter != null) {
                this.myPortWriter.close();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (this.myPort != null) {
                this.myPort.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.myPort = null;
        this.myPortReader = null;
        this.myPortWriter = null;
    }

    public synchronized boolean disconnect() {
        if (ConnectionStatus.DISCONNECTED == this.myConnectionStatus) {
            return true;
        }
        try {
            this.myPortReader.close();
        }
        catch (IOException ex) {
            this.addError(DEVICE_ERROR, "Unable to close Serial Port", ex);
        }
        try {
            this.myPortWriter.close();
        }
        catch (IOException ex) {
            this.addError(DEVICE_ERROR, "Unable to close Serial Port", ex);
        }
        try {
            this.myPort.close();
        }
        catch (Throwable ex) {
            this.addError(DEVICE_ERROR, "Unable to close Serial Port", ex);
        }
        this.myConnectionStatus = ConnectionStatus.DISCONNECTED;
        this.cleanup();
        return true;
    }

    public boolean reconnect() {
        this.clearErrors();
        this.disconnect();
        return this.connect(this.myBaudRate, this.myDataBtis, this.myStopBits, this.myParity);
    }

    public synchronized boolean write(byte[] data, int offset, int len) {
        if (ConnectionStatus.DISCONNECTED == this.myConnectionStatus) {
            return false;
        }
        try {
            this.myPortWriter.write(data, offset, len);
            return true;
        }
        catch (IOException ex) {
            this.addError(WRITE_ERROR, ex);
        }
        catch (Throwable t) {
            this.addError(WRITE_ERROR, t);
        }
        return false;
    }

    public boolean write(byte ... data) {
        return this.write(data, 0, data.length);
    }

    public synchronized boolean flushWriter() {
        if (ConnectionStatus.DISCONNECTED == this.myConnectionStatus) {
            return false;
        }
        try {
            this.myPortWriter.flush();
            return true;
        }
        catch (IOException ex) {
            this.addError(WRITE_ERROR, ex);
        }
        catch (Throwable t) {
            this.addError(WRITE_ERROR, t);
        }
        return false;
    }

    public byte[] read(int len) {
        return this.read(len, this.myTimeoutLength);
    }

    public byte[] read(int len, int timeout) {
        byte[] data = new byte[len];
        if (this.read(data, 0, len, timeout) == -1) {
            return null;
        }
        return data;
    }

    public int read(byte[] data, int offset, int len) {
        return this.read(data, offset, len, this.myTimeoutLength);
    }

    public synchronized int read(byte[] data, int offset, int len, int timeout) {
        if (ConnectionStatus.DISCONNECTED == this.myConnectionStatus) {
            return -1;
        }
        try {
            int count;
            long start = TimeUtils.now();
            long elapsed = 0L;
            int total = 0;
            do {
                count = this.myPortReader.read(data, offset, len);
                total += count;
                offset += count;
                elapsed = TimeUtils.now() - start;
            } while ((len -= count) > 0 && elapsed < (long)this.myTimeoutLength);
            if (len > 0) {
                // empty if block
            }
            return total;
        }
        catch (IOException ex) {
            this.addError(READ_ERROR, ex);
        }
        catch (Throwable t) {
            this.addError(READ_ERROR, t);
        }
        return -1;
    }

    public int read() {
        if (ConnectionStatus.DISCONNECTED == this.myConnectionStatus) {
            return -1;
        }
        try {
            long start = TimeUtils.now();
            long elapsed = 0L;
            int b = -1;
            do {
                b = this.myPortReader.read();
                elapsed = TimeUtils.now() - start;
            } while (b == -1 && elapsed < (long)this.myTimeoutLength);
            return b;
        }
        catch (IOException ex) {
            this.addError(READ_ERROR, ex);
        }
        catch (Throwable t) {
            this.addError(READ_ERROR, t);
        }
        return -1;
    }

    public synchronized void clearReader() {
        if (ConnectionStatus.DISCONNECTED == this.myConnectionStatus) {
            return;
        }
        try {
            int n = this.myPortReader.available();
            this.myPortReader.skip(n);
        }
        catch (IOException ex) {
            this.addError(READ_ERROR, ex);
        }
        catch (Throwable t) {
            this.addError(READ_ERROR, t);
        }
    }

    public ConnectionStatus getConnectionStatus() {
        return this.myConnectionStatus;
    }

    protected void addError(String error) {
        this.addError(error, null, null);
    }

    protected void addError(String error, String message) {
        this.addError(error, message, null);
    }

    protected void addError(String error, Throwable t) {
        this.addError(error, null, t);
    }

    public void addError(String error, String message, Throwable t) {
        this.myErrors.add(error);
        if (ConnectionStatus.CONNECTION_ERROR != this.myConnectionStatus) {
            this.myPreviousStatus = this.myConnectionStatus;
        }
        this.myConnectionStatus = ConnectionStatus.CONNECTION_ERROR;
        if (t == null && message == null) {
            theLogger.log(Level.SEVERE, "Serial Port Error on port: {0}.  Error: {1}.", new Object[]{this.myPortName, error});
        } else if (message == null) {
            theLogger.log(Level.SEVERE, "Serial Port Error on port: " + this.myPortName + ".  Error: " + error + ".", t);
        } else if (t == null) {
            theLogger.log(Level.SEVERE, "Serial Port Error on port: {0}.  Error: {1} ({2}).", new Object[]{this.myPortName, error, message});
        } else {
            theLogger.log(Level.SEVERE, "Serial Port Error on port: " + this.myPortName + ".  Error: " + error + " (" + message + ").", t);
        }
        this.firePropertyChange(PROP_ERRORS, null, this.myErrors);
    }

    public List<String> getErrors() {
        return this.myErrors;
    }

    public void clearErrors() {
        this.myErrors.clear();
        if (ConnectionStatus.CONNECTION_ERROR == this.myConnectionStatus) {
            this.myConnectionStatus = this.myPreviousStatus;
        }
        this.firePropertyChange(PROP_ERRORS, null, this.myErrors);
    }

    public boolean hasErrors() {
        return !this.myErrors.isEmpty();
    }
}

