/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.messaging;

import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.core.Adapter;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.protocol.MotionFrame;
import org.mechio.api.motion.protocol.MotionFrameEvent;
import org.mechio.impl.motion.messaging.MotionFrameEventRecord;
import org.mechio.impl.motion.messaging.MotionFrameRecord;
import org.mechio.impl.motion.messaging.MotionMessagingUtils;

public class PortableMotionFrameEvent
implements MotionFrameEvent {
    private MotionFrameEventRecord myFrameEventRecord;
    private MotionFrame<Robot.RobotPositionMap> myCachedMotionFrame;

    public PortableMotionFrameEvent(MotionFrameEventRecord frameEventRec) {
        if (frameEventRec == null) {
            throw new NullPointerException();
        }
        this.myFrameEventRecord = frameEventRec;
    }

    public PortableMotionFrameEvent(String sourceId, String destinationId, long currentTimeMillisecUTC, MotionFrame<Robot.RobotPositionMap> motionFrame) {
        if (sourceId == null || destinationId == null || motionFrame == null) {
            throw new NullPointerException();
        }
        this.myFrameEventRecord = new MotionFrameEventRecord();
        this.myFrameEventRecord.setSourceId(sourceId);
        this.myFrameEventRecord.setDestinationId(destinationId);
        this.myFrameEventRecord.setCurrentTimeMillisecUTC(currentTimeMillisecUTC);
        this.myFrameEventRecord.setMotionFrame(MotionMessagingUtils.packMotionFrame(motionFrame));
        this.myCachedMotionFrame = motionFrame;
    }

    public PortableMotionFrameEvent(MotionFrameEvent frameEvent) {
        if (frameEvent == null) {
            throw new NullPointerException();
        }
        if (frameEvent instanceof PortableMotionFrameEvent) {
            this.myFrameEventRecord = ((PortableMotionFrameEvent)frameEvent).myFrameEventRecord;
            this.myCachedMotionFrame = ((PortableMotionFrameEvent)frameEvent).myCachedMotionFrame;
            return;
        }
        this.myFrameEventRecord = new MotionFrameEventRecord();
        this.myFrameEventRecord.setSourceId(frameEvent.getSourceId());
        this.myFrameEventRecord.setDestinationId(frameEvent.getDestinationId());
        this.myFrameEventRecord.setCurrentTimeMillisecUTC(frameEvent.getTimestampMillisecUTC());
        this.myFrameEventRecord.setMotionFrame(MotionMessagingUtils.packMotionFrame((MotionFrame<Robot.RobotPositionMap>)frameEvent.getMotionFrame()));
        this.myCachedMotionFrame = frameEvent.getMotionFrame();
    }

    public String getSourceId() {
        return this.myFrameEventRecord.getSourceId();
    }

    public String getDestinationId() {
        return this.myFrameEventRecord.getDestinationId();
    }

    public long getTimestampMillisecUTC() {
        return this.myFrameEventRecord.getCurrentTimeMillisecUTC();
    }

    public MotionFrame<Robot.RobotPositionMap> getMotionFrame() {
        if (this.myCachedMotionFrame == null) {
            MotionFrameRecord frameRec = this.myFrameEventRecord.getMotionFrame();
            this.myCachedMotionFrame = MotionMessagingUtils.unpackMotionFrame(frameRec);
        }
        return this.myCachedMotionFrame;
    }

    public MotionFrameEventRecord getRecord() {
        return this.myFrameEventRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<MotionFrameEventRecord, MotionFrameEvent> {
        public MotionFrameEvent adapt(MotionFrameEventRecord a) {
            return new PortableMotionFrameEvent(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<MotionFrameEvent, MotionFrameEventRecord> {
        public MotionFrameEventRecord adapt(MotionFrameEvent a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableMotionFrameEvent(a).getRecord();
        }
    }

    public static class Factory
    implements MotionFrameEvent.MotionFrameEventFactory {
        public MotionFrameEvent createMotionFrameEvent(String sourceId, String destId, MotionFrame<Robot.RobotPositionMap> motionFrame) {
            return new PortableMotionFrameEvent(sourceId, destId, TimeUtils.now(), motionFrame);
        }
    }
}

