/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.messaging;

import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.impl.messaging.rk.common.PolymorphicAdapter;
import org.jflux.impl.messaging.rk.utils.JMSAvroPolymorphicBytesRecordAdapter;
import org.jflux.impl.messaging.rk.utils.JMSAvroPolymorphicRecordBytesAdapter;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.messaging.RobotResponseFactory;
import org.mechio.api.motion.protocol.RobotDefinitionResponse;
import org.mechio.api.motion.protocol.RobotResponse;
import org.mechio.impl.motion.messaging.PortableRobotDefinitionResponse;
import org.mechio.impl.motion.messaging.PortableRobotPositionResponse;
import org.mechio.impl.motion.messaging.PortableRobotResponseHeader;
import org.mechio.impl.motion.messaging.PortableRobotStatusResponse;
import org.mechio.impl.motion.messaging.RobotDefinitionResponseRecord;
import org.mechio.impl.motion.messaging.RobotPositionResponseRecord;
import org.mechio.impl.motion.messaging.RobotStatusResponseRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortableRobotResponse {
    private static final Logger theLogger = LoggerFactory.getLogger(PortableRobotResponse.class);
    public static final String MIME_ROBOT_DEFINITION_RESPONSE = "application/avro-robot-def-resp";
    public static final String MIME_ROBOT_STATUS_RESPONSE = "application/avro-robot-stat-resp";
    public static final String MIME_ROBOT_POSITION_RESPONSE = "application/avro-robot-pos-resp";

    public static class RobotResponseKeyAdapter
    implements PolymorphicAdapter.AdapterKeyMap<RobotResponse> {
        public String getKey(RobotResponse t) {
            if (t == null) {
                throw new NullPointerException();
            }
            if (t instanceof RobotDefinitionResponse) {
                return PortableRobotResponse.MIME_ROBOT_DEFINITION_RESPONSE;
            }
            if (t instanceof RobotResponse.RobotStatusResponse) {
                return PortableRobotResponse.MIME_ROBOT_STATUS_RESPONSE;
            }
            if (t instanceof RobotResponse.RobotPositionResponse) {
                return PortableRobotResponse.MIME_ROBOT_POSITION_RESPONSE;
            }
            return null;
        }
    }

    public static class MessageRecordAdapter
    extends JMSAvroPolymorphicRecordBytesAdapter<RobotResponse> {
        public MessageRecordAdapter() {
            super((PolymorphicAdapter.AdapterKeyMap)new RobotResponseKeyAdapter());
            this.addAdapter(new PortableRobotDefinitionResponse.MessageRecordAdapter(), PortableRobotResponse.MIME_ROBOT_DEFINITION_RESPONSE);
            this.addAdapter(new PortableRobotStatusResponse.MessageRecordAdapter(), PortableRobotResponse.MIME_ROBOT_STATUS_RESPONSE);
            this.addAdapter(new PortableRobotPositionResponse.MessageRecordAdapter(), PortableRobotResponse.MIME_ROBOT_POSITION_RESPONSE);
        }
    }

    public static class RecordMessageAdapter
    extends JMSAvroPolymorphicBytesRecordAdapter<RobotResponse> {
        public RecordMessageAdapter() {
            this.addAdapter(RobotDefinitionResponseRecord.class, RobotDefinitionResponseRecord.SCHEMA$, new PortableRobotDefinitionResponse.RecordMessageAdapter(), PortableRobotResponse.MIME_ROBOT_DEFINITION_RESPONSE);
            this.addAdapter(RobotPositionResponseRecord.class, RobotPositionResponseRecord.SCHEMA$, new PortableRobotPositionResponse.RecordMessageAdapter(), PortableRobotResponse.MIME_ROBOT_POSITION_RESPONSE);
            this.addAdapter(RobotStatusResponseRecord.class, RobotStatusResponseRecord.SCHEMA$, new PortableRobotStatusResponse.RecordMessageAdapter(), PortableRobotResponse.MIME_ROBOT_STATUS_RESPONSE);
        }
    }

    public static class Factory
    implements RobotResponseFactory {
        public RobotResponse.RobotResponseHeader createHeader(Robot.Id robotId, String sourceId, String destinationId, String commandType, long requesTimestamp) {
            return new PortableRobotResponseHeader(robotId, sourceId, destinationId, commandType, requesTimestamp, TimeUtils.now());
        }

        public RobotDefinitionResponse createDefinitionResponse(RobotResponse.RobotResponseHeader header, Robot robot) {
            return new PortableRobotDefinitionResponse(header, (Robot<? extends Joint>)robot);
        }

        public RobotResponse.RobotStatusResponse createStatusResponse(RobotResponse.RobotResponseHeader header, boolean status) {
            return new PortableRobotStatusResponse(header, status);
        }

        public RobotResponse.RobotPositionResponse createPositionResponse(RobotResponse.RobotResponseHeader header, Robot.RobotPositionMap positions) {
            return new PortableRobotPositionResponse(header, positions);
        }
    }
}

