/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.serial;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.property.PropertyChangeNotifier;
import org.mechio.api.motion.servos.ServoController;
import org.mechio.api.motion.servos.config.ServoConfig;
import org.mechio.api.motion.servos.config.ServoControllerConfig;
import org.mechio.impl.motion.serial.BaudRate;

public class SerialServoControllerConfig<Id, SC extends ServoConfig<Id>>
extends PropertyChangeNotifier
implements ServoControllerConfig<Id, SC>,
PropertyChangeListener {
    public static final String PROP_PORT_NAME = "PortName";
    public static final String PROP_BAUD_RATE = "BaudRate";
    private ServoController.Id myServoControllerId;
    private VersionProperty myControllerType;
    private Map<Id, SC> myServoConfigMap = new HashMap<Id, SC>();
    private String myPortName;
    private BaudRate myBaudRate;

    public SerialServoControllerConfig(String portName, BaudRate baud) {
        this();
        this.myPortName = portName;
        this.myBaudRate = baud;
    }

    protected SerialServoControllerConfig() {
    }

    public VersionProperty getControllerTypeVersion() {
        return this.myControllerType;
    }

    public void setControllerTypeVersion(VersionProperty version) {
        VersionProperty oldVer = this.myControllerType;
        this.myControllerType = version;
        this.firePropertyChange("controllerTypeVersion", oldVer, version);
    }

    public String getPortName() {
        return this.myPortName;
    }

    public void setPortName(String port) {
        String oldPort = this.myPortName;
        this.myPortName = port;
        this.firePropertyChange(PROP_PORT_NAME, oldPort, port);
    }

    public BaudRate getBaudRate() {
        return this.myBaudRate;
    }

    public void setBaudRate(BaudRate rate) {
        BaudRate oldRate = this.myBaudRate;
        this.myBaudRate = rate;
        this.firePropertyChange(PROP_BAUD_RATE, (Object)oldRate, (Object)rate);
    }

    public void addServoConfig(SC config) {
        Object id = config.getServoId();
        if (this.myServoConfigMap.containsKey(id)) {
            return;
        }
        this.myServoConfigMap.put(id, config);
        this.firePropertyChange("addServo", null, config);
    }

    public void removeServoConfig(SC config) {
        Object id = config.getServoId();
        if (!this.myServoConfigMap.containsKey(id)) {
            return;
        }
        this.myServoConfigMap.remove(id);
        this.firePropertyChange("removeServo", null, config);
    }

    public int getServoCount() {
        return this.myServoConfigMap.size();
    }

    public Map<Id, SC> getServoConfigs() {
        return Collections.unmodifiableMap(this.myServoConfigMap);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("logicalId".equals(name)) {
            this.changeServoId(evt.getOldValue(), evt.getNewValue());
            return;
        }
    }

    private void changeServoId(Id oldId, Id newId) {
        ServoConfig config = (ServoConfig)this.myServoConfigMap.remove(oldId);
        this.myServoConfigMap.put(newId, config);
        this.firePropertyChange("servos", null, this.myServoConfigMap);
    }

    public ServoController.Id getServoControllerId() {
        return this.myServoControllerId;
    }

    public void setServoControllerId(ServoController.Id scId) {
        this.myServoControllerId = scId;
    }
}

