/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.jointgroup;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.services.ConfigurationLoader;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.jointgroup.RobotJointGroupConfig;

public class RobotJointGroupConfigXMLReader
implements ConfigurationLoader<RobotJointGroupConfig, HierarchicalConfiguration> {
    private static final Logger theLogger = Logger.getLogger(RobotJointGroupConfigXMLReader.class.getName());
    public static final String CONFIG_TYPE = "RobotJointGroup XML";
    public static final String CONFIG_VERSION = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("RobotJointGroup XML", "1.0");
    public static final String XML_JOINT_GROUP = "JointGroup";
    public static final String XML_JOINT_GROUP_NAME_ATTR = "name";
    public static final String XML_ROBOT_ID = "RobotId";
    public static final String XML_JOINT_ID_LIST = "JointIds";
    public static final String XML_JOINT_ID = "JointId";
    public static final String XML_JOINT_GROUP_LIST = "JointGroups";

    public VersionProperty getConfigurationFormat() {
        return VERSION;
    }

    public RobotJointGroupConfig loadConfiguration(HierarchicalConfiguration param) {
        return RobotJointGroupConfigXMLReader.readJointGroup(null, param);
    }

    public Class<RobotJointGroupConfig> getConfigurationClass() {
        return RobotJointGroupConfig.class;
    }

    public Class<HierarchicalConfiguration> getParameterClass() {
        return HierarchicalConfiguration.class;
    }

    public static RobotJointGroupConfig loadJointGroup(String path) throws ConfigurationException, Throwable {
        RobotJointGroupConfig group = null;
        try {
            XMLConfiguration config = new XMLConfiguration(path);
            group = RobotJointGroupConfigXMLReader.readJointGroup(null, (HierarchicalConfiguration)config);
            return group;
        }
        catch (ConfigurationException t) {
            theLogger.log(Level.WARNING, "Cannont open XML file at: " + path, t);
            throw t;
        }
        catch (Throwable t) {
            theLogger.log(Level.SEVERE, "There was an error reading the JointGroup.", t);
            throw t;
        }
    }

    public static RobotJointGroupConfig readJointGroup(Robot.Id defDevId, HierarchicalConfiguration xml) {
        if (xml == null) {
            return null;
        }
        String nameKey = "[@name]";
        String name = xml.getString(nameKey, "Joint Group");
        List<Robot.JointId> ids = null;
        Robot.Id robotId = defDevId;
        if (robotId == null) {
            robotId = RobotJointGroupConfigXMLReader.readRobotId(xml);
        }
        if (robotId == null) {
            throw new IllegalArgumentException("Could not find RobotId element.");
        }
        List jointIdsXml = xml.configurationsAt(XML_JOINT_ID_LIST);
        if (!jointIdsXml.isEmpty()) {
            ids = RobotJointGroupConfigXMLReader.readJointIdList(robotId, (HierarchicalConfiguration)jointIdsXml.get(0));
        }
        List<RobotJointGroupConfig> groups = null;
        List groupsXml = xml.configurationsAt(XML_JOINT_GROUP_LIST);
        if (!groupsXml.isEmpty()) {
            groups = RobotJointGroupConfigXMLReader.readGroupList(robotId, (HierarchicalConfiguration)groupsXml.get(0));
        }
        RobotJointGroupConfig group = new RobotJointGroupConfig(name, robotId, ids, groups);
        return group;
    }

    private static Robot.Id readRobotId(HierarchicalConfiguration xml) {
        String idStr = xml.getString(XML_ROBOT_ID);
        if (idStr == null || idStr.isEmpty()) {
            return null;
        }
        return new Robot.Id(idStr);
    }

    private static List<Robot.JointId> readJointIdList(Robot.Id robotId, HierarchicalConfiguration xml) {
        List idsXml = xml.configurationsAt(XML_JOINT_ID);
        ArrayList<Robot.JointId> ids = new ArrayList<Robot.JointId>(idsXml.size());
        for (HierarchicalConfiguration conf : idsXml) {
            if (conf == null || conf.isEmpty()) {
                theLogger.warning("Skipping empty JointId element.");
                continue;
            }
            Integer id = conf.getInteger("", null);
            if (id == null) {
                theLogger.warning("Unable to parse JointId element.");
                continue;
            }
            ids.add(new Robot.JointId(robotId, new Joint.Id(id.intValue())));
        }
        return ids;
    }

    private static List<RobotJointGroupConfig> readGroupList(Robot.Id robotId, HierarchicalConfiguration xml) {
        List groupsXml = xml.configurationsAt(XML_JOINT_GROUP);
        ArrayList<RobotJointGroupConfig> groups = new ArrayList<RobotJointGroupConfig>(groupsXml.size());
        for (HierarchicalConfiguration conf : groupsXml) {
            if (conf == null || conf.isEmpty()) {
                theLogger.warning("Skipping empty JointGroup element.");
                continue;
            }
            RobotJointGroupConfig group = RobotJointGroupConfigXMLReader.readJointGroup(robotId, conf);
            if (group == null) {
                theLogger.warning("Unable to parse JointGroup element.");
                continue;
            }
            groups.add(group);
        }
        return groups;
    }
}

