/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.services.ConfigurationLoader;
import org.jflux.api.common.rk.services.ServiceConnectionDirectory;
import org.jflux.api.common.rk.services.ServiceContext;
import org.jflux.extern.utils.apache_commons_configuration.rk.XMLConfigUtils;
import org.jflux.impl.services.rk.osgi.OSGiUtils;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.servos.ServoController;
import org.mechio.api.motion.servos.ServoRobot;
import org.mechio.api.motion.servos.config.ServoControllerConfig;
import org.mechio.api.motion.servos.config.ServoRobotConfig;
import org.mechio.api.motion.servos.utils.ServoIdReader;
import org.mechio.api.motion.servos.utils.ServoJointAdapter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class RobotConfigXMLReader
implements ConfigurationLoader<ServoRobotConfig, HierarchicalConfiguration> {
    private static final Logger theLogger = Logger.getLogger(RobotConfigXMLReader.class.getName());
    public static final String CONFIG_TYPE = "Robot Configuration XML";
    public static final String CONFIG_VERSION = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("Robot Configuration XML", "1.0");
    public static final String XML_ROBOT_CONFIG = "Robot";
    public static final String XML_ROBOT_ID = "RobotId";
    public static final String XML_JOINT_CONFIG = "Joints";
    public static final String XML_JOINT = "Joint";
    public static final String XML_JOINT_JOINT_ID = "JointId";
    public static final String XML_JOINT_SERVO_CONTROLLER_ID = "ServoControllerId";
    public static final String XML_JOINT_SERVO_ID = "ServoId";
    public static final String XML_JOINT_NAME = "name";
    public static final String XML_CONTROLLERS = "ServoControllers";
    public static final String XML_CONTROLLER = "ServoControllerParameters";
    public static final String XML_VERSION_PROPERTIES = "Connector";
    public static final String XML_CONTROLLER_TYPE_VERSION = "ControllerType";
    public static final String XML_CONFIG_VERSION_TYPE = "ConfigFormat";
    public static final String XML_SERVO_CONTROLLER_CONFIG = "ServoControllerConfig";
    private BundleContext myContext;

    public static ServoRobotConfig readConfig(BundleContext context, String path) {
        return RobotConfigXMLReader.readConfig(context, XMLConfigUtils.loadXMLConfig((String)path));
    }

    public static ServoRobotConfig readConfig(BundleContext context, HierarchicalConfiguration xml) {
        if (context == null || xml == null) {
            throw new NullPointerException();
        }
        ServoRobotConfig config = new ServoRobotConfig();
        if (xml.isEmpty()) {
            return null;
        }
        HashMap<ServoController.Id, ServiceReference> readers = new HashMap<ServoController.Id, ServiceReference>();
        SubnodeConfiguration servos = xml.configurationAt(XML_JOINT_CONFIG);
        if (servos == null || servos.isEmpty()) {
            theLogger.log(Level.SEVERE, "Unable to find 'Joints' root element.");
            return null;
        }
        String id = xml.getString(XML_ROBOT_ID);
        config.setRobotId(new Robot.Id(id));
        SubnodeConfiguration controllers = xml.configurationAt(XML_CONTROLLERS);
        if (controllers == null || controllers.isEmpty()) {
            return config;
        }
        for (HierarchicalConfiguration cc : controllers.configurationsAt(XML_CONTROLLER)) {
            ServoRobot.ServoControllerContext controllerContext = RobotConfigXMLReader.readControllerParameters(context, cc, readers);
            if (controllerContext == null) {
                theLogger.log(Level.WARNING, "Unable to read ServoControllerContext.");
                continue;
            }
            config.addControllerContext(controllerContext);
        }
        List xmlJoints = servos.configurationsAt(XML_JOINT);
        for (HierarchicalConfiguration sc : xmlJoints) {
            RobotConfigXMLReader.addServo(context, sc, config, readers);
        }
        return config;
    }

    private static void addServo(BundleContext context, HierarchicalConfiguration xml, ServoRobotConfig robotConfig, Map<ServoController.Id, ServiceReference> readers) {
        Integer jointIdInt = xml.getInteger(XML_JOINT_JOINT_ID, null);
        String controllerIdStr = xml.getString(XML_JOINT_SERVO_CONTROLLER_ID, null);
        String servoIdStr = xml.getString(XML_JOINT_SERVO_ID, null);
        if (jointIdInt == null || controllerIdStr == null || servoIdStr == null) {
            if (jointIdInt == null) {
                theLogger.log(Level.WARNING, "Warning: found Joint element with no JointId attribute.");
            }
            if (controllerIdStr == null) {
                theLogger.log(Level.WARNING, "Warning: found Joint element with no ServoControllerId attribute.");
            }
            if (servoIdStr == null) {
                theLogger.log(Level.WARNING, "Warning: found Joint element with no ServoId attribute.");
            }
            return;
        }
        Joint.Id jId = new Joint.Id(jointIdInt.intValue());
        ServoController.Id cId = new ServoController.Id(controllerIdStr);
        ServiceReference ref = readers.get(cId);
        if (ref == null) {
            throw new NullPointerException("Could not find ServoIdReader for " + cId);
        }
        Object obj = context.getService(ref);
        if (obj == null || !(obj instanceof ServoIdReader)) {
            throw new NullPointerException("Could not find ServoIdReader for " + cId);
        }
        ServoIdReader reader = (ServoIdReader)obj;
        ServoController.ServoId sId = reader.read(cId, servoIdStr);
        if (sId == null) {
            throw new NullPointerException("Could not read ServoId for " + cId + ", " + servoIdStr);
        }
        robotConfig.addServoJoint(jId, sId);
    }

    private static ServoRobot.ServoControllerContext readControllerParameters(BundleContext context, HierarchicalConfiguration xml, Map<ServoController.Id, ServiceReference> readers) {
        ServoControllerConfig scc;
        SubnodeConfiguration versions = xml.configurationAt(XML_VERSION_PROPERTIES);
        Map vers = XMLConfigUtils.readVersions((HierarchicalConfiguration)versions, (String[])new String[]{XML_CONTROLLER_TYPE_VERSION, XML_CONFIG_VERSION_TYPE});
        VersionProperty controllerTypeVer = (VersionProperty)vers.get(XML_CONTROLLER_TYPE_VERSION);
        VersionProperty configVer = (VersionProperty)vers.get(XML_CONFIG_VERSION_TYPE);
        if (controllerTypeVer == null || configVer == null) {
            return null;
        }
        ServiceContext connection = ServiceConnectionDirectory.buildServiceContext((BundleContext)context, (VersionProperty)controllerTypeVer, (VersionProperty)configVer, ServoController.class, HierarchicalConfiguration.class);
        if (connection == null) {
            return null;
        }
        connection.setLoadParameter((Object)xml.configurationAt(XML_SERVO_CONTROLLER_CONFIG));
        try {
            connection.loadConfiguration();
            scc = (ServoControllerConfig)connection.getServiceConfiguration();
            scc.setControllerTypeVersion(controllerTypeVer);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Unable to load ServoControllerConfig", ex);
            return null;
        }
        ServoController.Id scId = scc.getServoControllerId();
        ServiceReference reader = RobotConfigXMLReader.getServoIdReader(context, scId, controllerTypeVer);
        if (reader == null) {
            throw new NullPointerException();
        }
        readers.put(scId, reader);
        ServoJointAdapter jointAdapter = RobotConfigXMLReader.getServoJointAdapter(context, scId, controllerTypeVer);
        if (jointAdapter == null) {
            throw new NullPointerException();
        }
        return new ServoRobot.ServoControllerContext(connection, jointAdapter);
    }

    private static ServiceReference getServoIdReader(BundleContext context, ServoController.Id scId, VersionProperty controllerTypeVer) {
        ServiceReference[] refs;
        String filter = OSGiUtils.createServiceFilter((String)"ServiceVersion", (String)controllerTypeVer.toString());
        try {
            refs = context.getServiceReferences(ServoIdReader.class.getName(), filter);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Invalid filter syntax: " + filter, ex);
            return null;
        }
        if (refs == null || refs.length == 0) {
            theLogger.log(Level.WARNING, "Could not find ServoIdReader for {0}", scId);
            return null;
        }
        return refs[0];
    }

    private static ServoJointAdapter getServoJointAdapter(BundleContext context, ServoController.Id scId, VersionProperty controllerTypeVer) {
        ServiceReference[] refs;
        String filter = OSGiUtils.createServiceFilter((String)"ServiceVersion", (String)controllerTypeVer.toString());
        try {
            refs = context.getServiceReferences(ServoJointAdapter.class.getName(), filter);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.WARNING, "Invalid filter syntax: " + filter, ex);
            return null;
        }
        if (refs == null || refs.length == 0) {
            theLogger.log(Level.WARNING, "Could not find ServoJointAdapter for {0}", scId);
            return null;
        }
        ServiceReference ref = refs[0];
        Object obj = context.getService(ref);
        if (obj == null || !(obj instanceof ServoJointAdapter)) {
            return null;
        }
        return (ServoJointAdapter)obj;
    }

    public RobotConfigXMLReader(BundleContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
    }

    public VersionProperty getConfigurationFormat() {
        return VERSION;
    }

    public ServoRobotConfig loadConfiguration(HierarchicalConfiguration param) {
        return RobotConfigXMLReader.readConfig(this.myContext, param);
    }

    public Class<ServoRobotConfig> getConfigurationClass() {
        return ServoRobotConfig.class;
    }

    public Class<HierarchicalConfiguration> getParameterClass() {
        return HierarchicalConfiguration.class;
    }
}

