/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.jflux.api.core.Adapter;
import org.jflux.impl.messaging.rk.config.MessagingLifecycleGroupConfigUtils;
import org.jflux.impl.messaging.rk.lifecycle.JMSAvroAsyncReceiverLifecycle;
import org.jflux.impl.messaging.rk.lifecycle.JMSAvroMessageSenderLifecycle;
import org.jflux.impl.messaging.rk.lifecycle.JMSAvroPolymorphicSenderLifecycle;
import org.jflux.impl.messaging.rk.utils.ConnectionUtils;
import org.jflux.impl.messaging.rk.utils.JMSAvroPolymorphicRecordBytesAdapter;
import org.jflux.impl.services.rk.lifecycle.ServiceLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.config.RKLifecycleConfigUtils;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceFactory;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceGroup;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponent;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponentFactory;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.lifecycle.RemoteRobotHostLifecycle;
import org.mechio.api.motion.lifecycle.RobotMoveHandlerLifecycle;
import org.mechio.api.motion.protocol.MotionFrameEvent;
import org.mechio.api.motion.protocol.RobotDefinitionResponse;
import org.mechio.api.motion.protocol.RobotRequest;
import org.mechio.api.motion.protocol.RobotResponse;
import org.mechio.impl.motion.messaging.MotionFrameEventRecord;
import org.mechio.impl.motion.messaging.PortableMotionFrameEvent;
import org.mechio.impl.motion.messaging.PortableRobotDefinitionResponse;
import org.mechio.impl.motion.messaging.PortableRobotRequest;
import org.mechio.impl.motion.messaging.PortableRobotResponse;
import org.mechio.impl.motion.messaging.RobotDefinitionResponseRecord;
import org.mechio.impl.motion.messaging.RobotRequestRecord;
import org.osgi.framework.BundleContext;

public class RemoteRobotHostServiceGroup
extends ManagedServiceGroup {
    private static final Logger theLogger = Logger.getLogger(RemoteRobotHostServiceGroup.class.getName());
    private static final String CONNECTION_ID = "motionConnection";
    private static final String REQUEST_DEST_ID = "robotRequest";
    private static final String RESPONSE_DEST_ID = "robotResponse";
    private static final String MOVE_DEST_ID = "robotMotionFrame";
    private static final String REQUEST_DEST = "robotRequest";
    private static final String RESPONSE_DEST = "robotResponse";
    private static final String MOVE_DEST = "motionFrame";
    private static final String REQUEST_RECEIVER_ID = "robotRequestReceiver";
    private static final String RESPONSE_SENDER_ID = "robotResponseSender";
    private static final String MOVE_RECEIVER_ID = "robotFrameReceiver";
    private static final String MOVE_HANDLER_ID = "robotMoveHandler";
    private static final String DEF_DEST = "robotDefinition";
    private static final String DEF_DEST_ID = "robotDefinition";
    private static final String DEF_SENDER_ID = "robotDefinitionSender";

    private static String getIdBase(Robot.Id robotId, String serviceId) {
        String base = "robot/" + robotId + "/" + serviceId;
        return base;
    }

    private static String getDestBase(Robot.Id robotId, String serviceId) {
        String base = "robot" + robotId + serviceId;
        base = base.replaceAll("[^a-zA-Z0-9]+", "");
        return base;
    }

    public RemoteRobotHostServiceGroup(BundleContext context, Robot.Id robotId, String hostId, String clientId, String connectionConfigId, Properties registrationProperties, String serial, int sendDataInterval) {
        super((ManagedServiceFactory)new OSGiComponentFactory(context), RemoteRobotHostServiceGroup.getLifecycles(robotId, hostId, clientId, serial, sendDataInterval), RemoteRobotHostServiceGroup.getIdBase(robotId, hostId), registrationProperties);
        String base = RemoteRobotHostServiceGroup.getIdBase(robotId, hostId);
        String dbase = RemoteRobotHostServiceGroup.getDestBase(robotId, hostId);
        RemoteRobotHostServiceGroup.connectJMS(context, connectionConfigId, RemoteRobotHostServiceGroup.id(base, CONNECTION_ID), RemoteRobotHostServiceGroup.id(base, CONNECTION_ID), RemoteRobotHostServiceGroup.id(base, "robotRequest"), RemoteRobotHostServiceGroup.dest(dbase, "robotRequest"), RemoteRobotHostServiceGroup.id(base, "robotResponse"), RemoteRobotHostServiceGroup.dest(dbase, "robotResponse"), RemoteRobotHostServiceGroup.id(base, MOVE_DEST_ID), RemoteRobotHostServiceGroup.dest(dbase, MOVE_DEST), RemoteRobotHostServiceGroup.id(base, "robotDefinition"), RemoteRobotHostServiceGroup.dest(dbase, "robotDefinition"), this.myServiceProperties);
    }

    private static List<ServiceLifecycleProvider> getLifecycles(Robot.Id robotId, String hostId, String clientId, String serial, int sendDataInterval) {
        String base = RemoteRobotHostServiceGroup.getIdBase(robotId, hostId);
        return RemoteRobotHostServiceGroup.getRemoteRobotHostServices(RemoteRobotHostServiceGroup.id(base, hostId), RemoteRobotHostServiceGroup.id(RemoteRobotHostServiceGroup.getIdBase(robotId, clientId), clientId), robotId, RemoteRobotHostServiceGroup.id(base, CONNECTION_ID), RemoteRobotHostServiceGroup.id(base, "robotRequest"), RemoteRobotHostServiceGroup.id(base, "robotResponse"), RemoteRobotHostServiceGroup.id(base, MOVE_DEST_ID), RemoteRobotHostServiceGroup.id(base, REQUEST_RECEIVER_ID), RemoteRobotHostServiceGroup.id(base, RESPONSE_SENDER_ID), RemoteRobotHostServiceGroup.id(base, MOVE_RECEIVER_ID), RemoteRobotHostServiceGroup.id(base, MOVE_HANDLER_ID), RemoteRobotHostServiceGroup.id(base, DEF_SENDER_ID), RemoteRobotHostServiceGroup.id(base, "robotDefinition"), serial, sendDataInterval);
    }

    private static List<ServiceLifecycleProvider> getRemoteRobotHostServices(String robotHostId, String robotClientId, Robot.Id robotId, String connectionId, String requestDestId, String responseDestId, String moveDestId, String requestReceiverId, String responseSenderId, String moveReceiverId, String moveHandlerId, String defSenderId, String defDestId, String serial, int sendDataInterval) {
        ArrayList<ServiceLifecycleProvider> lifecycles = new ArrayList<ServiceLifecycleProvider>();
        lifecycles.add((ServiceLifecycleProvider)new JMSAvroPolymorphicSenderLifecycle((JMSAvroPolymorphicRecordBytesAdapter)new PortableRobotResponse.MessageRecordAdapter(), RobotResponse.class, responseSenderId, connectionId, responseDestId));
        lifecycles.add((ServiceLifecycleProvider)new JMSAvroAsyncReceiverLifecycle((Adapter)new PortableRobotRequest.RecordMessageAdapter(), RobotRequest.class, RobotRequestRecord.class, RobotRequestRecord.SCHEMA$, requestReceiverId, connectionId, requestDestId));
        lifecycles.add((ServiceLifecycleProvider)new JMSAvroAsyncReceiverLifecycle((Adapter)new PortableMotionFrameEvent.RecordMessageAdapter(), MotionFrameEvent.class, MotionFrameEventRecord.class, MotionFrameEventRecord.SCHEMA$, moveReceiverId, connectionId, moveDestId));
        lifecycles.add((ServiceLifecycleProvider)new RobotMoveHandlerLifecycle(moveHandlerId, robotId));
        lifecycles.add((ServiceLifecycleProvider)new JMSAvroMessageSenderLifecycle((Adapter)new PortableRobotDefinitionResponse.MessageRecordAdapter(), RobotDefinitionResponse.class, RobotDefinitionResponseRecord.class, defSenderId, connectionId, defDestId));
        lifecycles.add((ServiceLifecycleProvider)new RemoteRobotHostLifecycle(robotHostId, robotClientId, robotId, requestReceiverId, responseSenderId, moveReceiverId, moveHandlerId, defSenderId, serial, sendDataInterval));
        return lifecycles;
    }

    private static void connectJMS(BundleContext context, String connectionConfigId, String connectionId, String sessionId, String requestDestId, String requestDestination, String responseDestId, String responseDestination, String moveDestId, String moveDestination, String defDestId, String defDestination, Properties registrationProps) {
        try {
            theLogger.info("Registering Motion Connection and Destinations");
            new OSGiComponent(context, new RKLifecycleConfigUtils.GenericLifecycleFactory().adapt(MessagingLifecycleGroupConfigUtils.buildConnectionLifecycleConfig((String)connectionConfigId, (String)connectionId))).start();
            new OSGiComponent(context, new RKLifecycleConfigUtils.GenericLifecycleFactory().adapt(MessagingLifecycleGroupConfigUtils.buildSessionLifecycleConfig((String)connectionId, (String)sessionId))).start();
            ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{requestDestId, requestDestination, 1, registrationProps, responseDestId, responseDestination, 1, registrationProps, moveDestId, moveDestination, 1, registrationProps, defDestId, defDestination, 1, registrationProps});
            theLogger.info("Motion Connection and Destinations Registered");
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private static String id(String base, String suffix) {
        return base + "/" + suffix;
    }

    private static String dest(String base, String suffix) {
        String combined = base + suffix;
        combined = combined.replaceAll("[^a-zA-Z0-9]+", "");
        return combined;
    }
}

