/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.test.configuration;

import java.util.LinkedHashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.meeuw.configuration.FixedSizeMap;

class FixedSizeMapTest {
    FixedSizeMapTest() {
    }

    @Test
    public void test() {
        LinkedHashMap<String, Integer> test = new LinkedHashMap<String, Integer>();
        test.put("a", 1);
        test.put("b", 1);
        FixedSizeMap fixed = new FixedSizeMap(test);
        fixed.put((Object)"a", (Object)2);
        Assertions.assertThatThrownBy(() -> fixed.put((Object)"c", (Object)3)).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThat((int)fixed.size()).isEqualTo(2);
        Assertions.assertThat((Integer)((Integer)fixed.get((Object)"a"))).isEqualTo(2);
        Assertions.assertThat((String)fixed.toString()).isEqualTo("{a=2, b=1}");
        Assertions.assertThatThrownBy(() -> fixed.remove((Object)"a")).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testWithKeys() {
        FixedSizeMap fixed = new FixedSizeMap((Object[])new String[]{"a", "b"});
        fixed.put((Object)"a", (Object)1);
        fixed.put((Object)"b", (Object)1);
        Assertions.assertThatThrownBy(() -> fixed.put((Object)"c", (Object)3)).isInstanceOf(UnsupportedOperationException.class);
        fixed.put((Object)"a", (Object)2);
        Assertions.assertThat((int)fixed.size()).isEqualTo(2);
        Assertions.assertThat((Integer)((Integer)fixed.get((Object)"a"))).isEqualTo(2);
        Assertions.assertThat((String)fixed.toString()).isEqualTo("{a=2, b=1}");
    }

    @Test
    public void testOf() {
        FixedSizeMap fixed = FixedSizeMap.of((Object[])new Object[]{"a", 1, "b", 1});
        fixed.put((Object)"a", (Object)3);
        Assertions.assertThatThrownBy(() -> fixed.put((Object)"c", (Object)3)).isInstanceOf(UnsupportedOperationException.class);
        fixed.put((Object)"a", (Object)2);
        Assertions.assertThat((int)fixed.size()).isEqualTo(2);
        Assertions.assertThat((Integer)((Integer)fixed.get((Object)"a"))).isEqualTo(2);
        Assertions.assertThat((String)fixed.toString()).isEqualTo("{a=2, b=1}");
        Assertions.assertThatThrownBy(() -> FixedSizeMap.of((Object[])new Object[]{"a", 1, "b", 2, "c"})).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> FixedSizeMap.of((Object[])new Object[]{"a", 1, 2, "b"})).isInstanceOf(ClassCastException.class);
        Assertions.assertThatThrownBy(() -> FixedSizeMap.of((Object[])new Object[]{"a", 1, "b", "b"})).isInstanceOf(ClassCastException.class);
        Assertions.assertThatThrownBy(() -> FixedSizeMap.of((Object[])new Object[]{"a", null, "b", 2, "c", "c"})).isInstanceOf(ClassCastException.class);
        Assertions.assertThatThrownBy(() -> FixedSizeMap.of((Object[])new Object[]{"a", 1, null, 2})).isInstanceOf(IllegalArgumentException.class);
    }
}

