/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.test.configuration;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.meeuw.configuration.StringConversionService;
import org.meeuw.test.configuration.A;
import org.meeuw.test.configuration.spi.TestConfigurationAspect;

public class StringConversionServiceTest {
    @Test
    public void intToString() {
        Assertions.assertThat((Optional)StringConversionService.toString((Object)1)).contains((Object)"1");
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"1", Integer.TYPE)).contains((Object)1);
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"xx", Integer.TYPE)).isEmpty();
    }

    @Test
    public void fromInteger() {
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"1", Integer.class)).contains((Object)1);
    }

    @Test
    public void longToString() {
        Assertions.assertThat((Optional)StringConversionService.toString((Object)2L)).contains((Object)"2");
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"2", Long.TYPE)).contains((Object)2L);
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"2", Long.class)).contains((Object)2L);
    }

    @Test
    public void floatToString() {
        Assertions.assertThat((Optional)StringConversionService.toString((Object)Float.valueOf(1.0f))).contains((Object)"1.0");
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"1.0", Float.TYPE)).contains((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"1.0", Float.class)).contains((Object)Float.valueOf(1.0f));
    }

    @Test
    public void doubleToString() {
        Assertions.assertThat((Optional)StringConversionService.toString((Object)1.0)).contains((Object)"1.0");
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"1.0", Double.TYPE)).contains((Object)1.0);
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"1.0", Double.class)).contains((Object)1.0);
    }

    @Test
    public void booleanToString() {
        Assertions.assertThat((Optional)StringConversionService.toString((Object)true)).contains((Object)"true");
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"true", Boolean.TYPE)).contains((Object)Boolean.TRUE);
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"false", Boolean.class)).contains((Object)false);
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"xxx", Boolean.class)).isEmpty();
    }

    @Test
    public void enumToString() {
        Assertions.assertThat((Optional)StringConversionService.toString((Object)((Object)A.x))).contains((Object)"x");
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"y", A.class)).contains((Object)A.y);
        Assertions.assertThat((Optional)StringConversionService.fromString((String)"xxx", A.class)).isEmpty();
    }

    @Test
    public void someSerializable() {
        Assertions.assertThat((Optional)StringConversionService.toString((Object)new TestConfigurationAspect.SomeSerializable(1, "b"))).isEmpty();
    }
}

