/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import lombok.Generated;

public class ReflectionUtils {
    @Generated
    private static final Logger log = Logger.getLogger(ReflectionUtils.class.getName());

    private ReflectionUtils() {
    }

    public static <C, D> void forConstants(Class<C> clazz, Class<D> constantClass, Consumer<D> consumer) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || !constantClass.isAssignableFrom(f.getType())) continue;
            try {
                consumer.accept(f.get(null));
            }
            catch (IllegalAccessException e) {
                assert (false) : e.getMessage();
            }
        }
    }

    public static <C> void forConstants(Class<C> clazz, Consumer<C> consumer) {
        ReflectionUtils.forConstants(clazz, clazz, consumer);
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... params) {
        return clazz.getDeclaredMethod(name, params);
    }

    public static Method getDeclaredBinaryMethod(Class<?> clazz, String name) {
        return ReflectionUtils.getDeclaredMethod(clazz, name, clazz);
    }

    public static Deque<Class<?>> commonSuperClass(List<Class<?>> classes) {
        Iterator<Class<?>> iterator = classes.iterator();
        LinkedHashSet rollingIntersect = new LinkedHashSet(ReflectionUtils.getClassesBfs(iterator.next()));
        iterator.forEachRemaining(c -> rollingIntersect.retainAll(ReflectionUtils.getClassesBfs(c)));
        return new LinkedList(rollingIntersect);
    }

    private static Set<Class<?>> getClassesBfs(Class<?> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        LinkedHashSet nextLevel = new LinkedHashSet();
        nextLevel.add(clazz);
        do {
            classes.addAll(nextLevel);
            LinkedHashSet thisLevel = new LinkedHashSet(nextLevel);
            nextLevel.clear();
            for (Class each : thisLevel) {
                Class superClass = each.getSuperclass();
                if (superClass != null && superClass != Object.class) {
                    nextLevel.add(superClass);
                }
                Collections.addAll(nextLevel, each.getInterfaces());
            }
        } while (!nextLevel.isEmpty());
        return classes;
    }
}

