/*
 *  Copyright 2022 Michiel Meeuwissen
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        https://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
import org.meeuw.configuration.ConfigurationAspect;
import org.meeuw.configuration.spi.*;

/**
 * @author Michiel Meeuwissen
 * @since 0.4
 */
module org.meeuw.configuration {
    requires static lombok;
    requires static org.checkerframework.checker.qual;

    requires java.logging;
    requires java.prefs;

    exports org.meeuw.configuration;
    exports org.meeuw.configuration.spi;

    uses ConfigurationAspect;
    uses ToStringProvider;

    provides ToStringProvider with
        EnumToString,
        StringToString,
        DoubleToString,
        FloatToString,
        LongToString,
        IntegerToString,
        BooleanToString
        ;
}

