/*
 *  Copyright 2022 Michiel Meeuwissen
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        https://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package org.meeuw.configuration;

/**
 * Exception thrown related to configuration issues. E.g. thrown by {@link Configuration#getAspect(Class)} when there is no such configuration aspect.
 * @author Michiel Meeuwissen
 * @since 0.4
 */
public class ConfigurationException  extends RuntimeException {
    public ConfigurationException(String s) {
        super(s);
    }
}
