/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import lombok.Generated;
import org.meeuw.configuration.Configuration;
import org.meeuw.configuration.ConfigurationAspect;
import org.meeuw.configuration.ConfigurationPreferences;
import org.meeuw.configuration.FixedSizeMap;

public class ConfigurationService {
    @Generated
    private static final Logger log = Logger.getLogger(ConfigurationService.class.getName());
    private static final Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> INITIAL_MAP = Collections.unmodifiableMap(ConfigurationService.createInitialConfigurationMap());
    private static final Configuration.Builder DEFAULT = Configuration.builder();
    private static boolean useUserPreferences = false;
    public static Reset RESET_TO_DEFAULTS = new Reset();
    public static final ThreadLocal<Configuration> CONFIGURATION = ThreadLocal.withInitial(DEFAULT::build);

    private ConfigurationService() {
    }

    public static void setupUserPreferences() {
        useUserPreferences = true;
        ConfigurationService.readDefaults();
        ConfigurationPreferences.addPreferenceChangeListener(DEFAULT);
        ConfigurationService.storeDefaults();
        log.info(() -> "Set up " + String.valueOf(ConfigurationPreferences.getUserPreferences()));
    }

    public static void defaultConfiguration(Consumer<Configuration.Builder> consumer) {
        consumer.accept(DEFAULT);
        ConfigurationService.storeDefaults();
        CONFIGURATION.remove();
    }

    public static Configuration getConfiguration() {
        return CONFIGURATION.get();
    }

    public static void setConfiguration(Configuration configuration) {
        CONFIGURATION.set(configuration);
    }

    public static Reset setConfiguration(Configuration configuration, Consumer<Configuration.Builder> consumer) {
        Configuration.Builder builder = configuration.toBuilder();
        consumer.accept(builder);
        ConfigurationService.setConfiguration(builder);
        return RESET_TO_DEFAULTS;
    }

    public static Reset setConfiguration(Consumer<Configuration.Builder> consumer) {
        return ConfigurationService.setConfiguration(ConfigurationService.getConfiguration(), consumer);
    }

    public static void setConfiguration(Configuration.Builder configuration) {
        ConfigurationService.setConfiguration(configuration.build());
    }

    public static void resetToDefaults() {
        CONFIGURATION.remove();
    }

    public static void resetToDefaultDefaults() {
        ConfigurationService.defaultConfiguration(Configuration.Builder::defaults);
    }

    public static boolean sync() {
        try {
            ConfigurationPreferences.sync();
            return true;
        }
        catch (BackingStoreException bs) {
            log.warning(bs.getClass().getName() + ": " + bs.getMessage());
            return false;
        }
    }

    public static <E extends ConfigurationAspect> E getConfigurationAspect(Class<E> clazz) {
        return CONFIGURATION.get().getAspect(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R withConfiguration(Configuration configuration, Supplier<R> supplier) {
        Configuration before = ConfigurationService.getConfiguration();
        try {
            ConfigurationService.setConfiguration(configuration);
            R r = supplier.get();
            return r;
        }
        finally {
            ConfigurationService.setConfiguration(before);
        }
    }

    public static void withConfiguration(Configuration configuration, Runnable r) {
        ConfigurationService.withConfiguration(configuration, ConfigurationService.supplier(r));
    }

    public static <E extends ConfigurationAspect, R> R withAspect(Class<E> configurationAspectClass, UnaryOperator<E> aspectConfigurer, Supplier<R> r) {
        return ConfigurationService.withConfiguration(ConfigurationService.getConfiguration().with(configurationAspectClass, aspectConfigurer), r);
    }

    public static <E extends ConfigurationAspect> void withAspect(Class<E> configurationAspectClass, UnaryOperator<E> aspectConfigurer, Runnable r) {
        ConfigurationService.withAspect(configurationAspectClass, aspectConfigurer, ConfigurationService.supplier(r));
    }

    public static <E extends ConfigurationAspect> void withAspect(E configurationAspect, Runnable r) {
        ConfigurationService.withAspect(configurationAspect, ConfigurationService.supplier(r));
    }

    public static <E extends ConfigurationAspect, R> R withAspect(E configurationAspect, Supplier<R> r) {
        return ConfigurationService.withConfiguration(ConfigurationService.getConfiguration().toBuilder().aspectValue(configurationAspect).build(), r);
    }

    public static void withConfiguration(Consumer<Configuration.Builder> configuration, Runnable runnable) {
        Configuration.Builder builder = ConfigurationService.getConfiguration().toBuilder();
        configuration.accept(builder);
        ConfigurationService.withConfiguration(builder.build(), runnable);
    }

    static void storeDefaults() {
        if (useUserPreferences) {
            ConfigurationPreferences.storeDefaults(DEFAULT.build());
        }
    }

    static void readDefaults() {
        if (useUserPreferences) {
            ConfigurationPreferences.readDefaults(DEFAULT);
        }
    }

    static FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect> newConfigurationMap() {
        Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> copy = ConfigurationService.createEmptyMap();
        copy.putAll(INITIAL_MAP);
        return new FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect>(copy);
    }

    private static FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect> createInitialConfigurationMap() {
        Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> m = ConfigurationService.createEmptyMap();
        ServiceLoader<ConfigurationAspect> loader = ServiceLoader.load(ConfigurationAspect.class);
        Iterator<ConfigurationAspect> iterator = loader.iterator();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    ConfigurationAspect configurationAspect = iterator.next();
                    log.finer(() -> "Found " + configurationAspect.getClass().getCanonicalName());
                    m.put(configurationAspect.getClass(), configurationAspect);
                }
            }
            catch (ServiceConfigurationError se) {
                log.log(Level.WARNING, se.getMessage(), se);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            break;
        }
        return new FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect>(m);
    }

    private static Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> createEmptyMap() {
        return new TreeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect>(Comparator.comparing(Class::getCanonicalName));
    }

    private static Supplier<Void> supplier(Runnable r) {
        return () -> {
            r.run();
            return null;
        };
    }

    public static class Reset
    implements AutoCloseable {
        private Reset() {
        }

        @Override
        public void close() {
            ConfigurationService.resetToDefaults();
        }
    }
}

