/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class FixedSizeMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> wrapped;

    public FixedSizeMap(Map<K, V> wrapped) {
        this.wrapped = wrapped;
    }

    @SafeVarargs
    public FixedSizeMap(K ... keys) {
        this.wrapped = new LinkedHashMap();
        for (K key : keys) {
            this.wrapped.put(key, null);
        }
    }

    public static <K, V> FixedSizeMap<K, V> of(Object ... keysAndValues) {
        LinkedHashMap<Object, Object> wrapped = new LinkedHashMap<Object, Object>();
        Class<?> keyType = null;
        Class<?> valueType = null;
        for (int i = 0; i < keysAndValues.length; i += 2) {
            Object key = keysAndValues[i];
            if (key == null) {
                throw new IllegalArgumentException("keys cannot be null");
            }
            if (keyType == null) {
                keyType = key.getClass();
            } else if (!keyType.isAssignableFrom(key.getClass())) {
                throw new ClassCastException("Key " + String.valueOf(key) + " has unexpected type (not assignable to " + String.valueOf(keyType) + ")");
            }
            Object value = keysAndValues[i + 1];
            if (value != null) {
                if (valueType == null) {
                    valueType = value.getClass();
                } else if (!valueType.isAssignableFrom(value.getClass())) {
                    throw new ClassCastException("Value " + String.valueOf(value) + " has unexpected type (not assignable to " + String.valueOf(valueType) + ")");
                }
            }
            wrapped.put(key, value);
        }
        return new FixedSizeMap(wrapped);
    }

    @Override
    public V put(K k, V v) {
        if (this.wrapped.containsKey(k)) {
            return this.wrapped.put(k, v);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object k) {
        return this.wrapped.get(k);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator wrappedIterator = FixedSizeMap.this.wrapped.entrySet().iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return wrappedIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return (Map.Entry)wrappedIterator.next();
                    }
                };
            }

            @Override
            public int size() {
                return FixedSizeMap.this.wrapped.size();
            }
        };
    }
}

