/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.stream.Stream;
import lombok.Generated;
import org.meeuw.configuration.spi.ToStringProvider;

public class StringConversionService {
    @Generated
    private static final Logger log = Logger.getLogger(StringConversionService.class.getName());

    private StringConversionService() {
    }

    public static <C> Optional<String> toString(C value) {
        return StringConversionService.stream().sorted().map(tp -> {
            String result = tp.toString(value).orElse(null);
            if (result != null) {
                log.fine(() -> String.format("%s -> %s", tp, result));
            }
            return result;
        }).filter(Objects::nonNull).findFirst();
    }

    public static <C> Optional<C> fromString(String value, Class<? extends C> type) {
        return StringConversionService.stream().sorted().map(tp -> tp.fromString(type, value).orElse(null)).filter(Objects::nonNull).findFirst();
    }

    static Stream<ToStringProvider<?>> stream() {
        ServiceLoader<ToStringProvider> loader = ServiceLoader.load(ToStringProvider.class);
        ArrayList list = new ArrayList();
        loader.iterator().forEachRemaining(list::add);
        return list.stream();
    }
}

