/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.logging.Logger;
import lombok.Generated;
import org.meeuw.configuration.Configuration;
import org.meeuw.configuration.ConfigurationAspect;
import org.meeuw.configuration.FixedSizeMap;

public class ConfigurationService {
    @Generated
    private static final Logger log = Logger.getLogger(ConfigurationService.class.getName());
    private static final Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> INITIAL_MAP = Collections.unmodifiableMap(ConfigurationService.createConfigurationMap());
    private static final Configuration.Builder DEFAULT = Configuration.builder();
    public static final ThreadLocal<Configuration> CONFIGURATION = ThreadLocal.withInitial(DEFAULT::build);

    private ConfigurationService() {
    }

    public static void defaultConfiguration(Consumer<Configuration.Builder> consumer) {
        consumer.accept(DEFAULT);
        CONFIGURATION.remove();
    }

    public static Configuration getConfiguration() {
        return CONFIGURATION.get();
    }

    public static void setConfiguration(Configuration configuration) {
        CONFIGURATION.set(configuration);
    }

    public static void resetToDefaults() {
        CONFIGURATION.remove();
    }

    public static void resetToDefaultDefaults() {
        ConfigurationService.defaultConfiguration(Configuration.Builder::defaults);
    }

    public static <E extends ConfigurationAspect> E getConfigurationAspect(Class<E> clazz) {
        return CONFIGURATION.get().getAspect(clazz);
    }

    public static void with(Configuration configuration, Runnable r) {
        ConfigurationService.with(configuration, () -> {
            r.run();
            return null;
        });
    }

    public static <E extends ConfigurationAspect, R> R with(Class<E> configurationAspect, UnaryOperator<E> aspect, Supplier<R> r) {
        return ConfigurationService.with(ConfigurationService.getConfiguration().with(configurationAspect, aspect), r);
    }

    public static <E extends ConfigurationAspect> void with(Class<E> configurationAspect, UnaryOperator<E> aspect, Runnable r) {
        ConfigurationService.with(ConfigurationService.getConfiguration().with(configurationAspect, aspect), () -> {
            r.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R with(Configuration configuration, Supplier<R> r) {
        Configuration before = CONFIGURATION.get();
        try {
            CONFIGURATION.set(configuration);
            R r2 = r.get();
            return r2;
        }
        finally {
            CONFIGURATION.set(before);
        }
    }

    public static void with(Consumer<Configuration.Builder> configuration, Runnable r) {
        Configuration.Builder builder = CONFIGURATION.get().toBuilder();
        configuration.accept(builder);
        ConfigurationService.with(builder.build(), r);
    }

    public static FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect> newConfigurationMap() {
        Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> copy = ConfigurationService.createEmptyMap();
        copy.putAll(INITIAL_MAP);
        return new FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect>(copy);
    }

    private static FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect> createConfigurationMap() {
        Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> m = ConfigurationService.createEmptyMap();
        ServiceLoader<ConfigurationAspect> loader = ServiceLoader.load(ConfigurationAspect.class);
        loader.iterator().forEachRemaining(configurationAspect -> m.put((Class<? extends ConfigurationAspect>)configurationAspect.getClass(), (ConfigurationAspect)configurationAspect));
        return new FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect>(m);
    }

    private static Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> createEmptyMap() {
        return new TreeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect>(Comparator.comparing(Class::getSimpleName));
    }
}

