/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.test.configuration;

import java.time.Instant;
import java.util.List;
import java.util.logging.Logger;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.meeuw.configuration.Configuration;
import org.meeuw.configuration.ConfigurationAspect;
import org.meeuw.configuration.ConfigurationException;
import org.meeuw.configuration.ConfigurationService;
import org.meeuw.test.configuration.spi.InvalidConfigurationAspect;
import org.meeuw.test.configuration.spi.TestConfigurationAspect;
import org.meeuw.test.configuration.spi.TestProvider;
import org.meeuw.test.configuration.spi.Unregistered;

public class ConfigurationServiceTest {
    @Generated
    private static final Logger log = Logger.getLogger(ConfigurationServiceTest.class.getName());

    @Test
    public void invalidConfigurationAspect() {
        Assertions.assertThatThrownBy(() -> ConfigurationService.getConfiguration().getAspect(Unregistered.class)).isInstanceOf(ConfigurationException.class);
    }

    @Test
    public void store() {
        long previous = ((TestConfigurationAspect)ConfigurationService.getConfigurationAspect(TestConfigurationAspect.class)).getSomeLong();
        log.info("previous " + Instant.ofEpochMilli(previous));
        ConfigurationService.defaultConfiguration(builder -> builder.configure(TestConfigurationAspect.class, c -> c.withSomeLong(System.currentTimeMillis()).withSomeString("foobar")));
    }

    @Test
    public void getAndSetConfiguration() {
        Configuration configuration = ConfigurationService.getConfiguration();
        TestConfigurationAspect aspect = (TestConfigurationAspect)configuration.getAspect(TestConfigurationAspect.class);
        int someInt = aspect.getSomeInt();
        log.info(() -> String.format("some int: %d", someInt));
        ConfigurationService.setConfiguration((Configuration)configuration.toBuilder().configure(TestConfigurationAspect.class, nc -> nc.withSomeInt(8)).build());
        Assertions.assertThat((Integer)((Integer)ConfigurationService.getConfiguration().getAspectValue(TestConfigurationAspect.class, TestConfigurationAspect::getSomeInt))).isEqualTo(8);
    }

    @Test
    public void testConfigurationAspects() {
        ConfigurationService.defaultConfiguration(con -> con.configure(TestConfigurationAspect.class, c -> c.withSomeInt(4).withSomeSerializable(null).withNotSerializable(new TestConfigurationAspect.NotSerializable(3, "x"))));
        Assertions.assertThat((int)((TestConfigurationAspect)ConfigurationService.getConfigurationAspect(TestConfigurationAspect.class)).getSomeInt()).isEqualTo(4);
        ConfigurationService.resetToDefaultDefaults();
        Assertions.assertThat((boolean)ConfigurationService.sync()).isTrue();
        ConfigurationService.withAspect(TestConfigurationAspect.class, b -> b.withSomeInt(6), () -> Assertions.assertThat((int)((TestConfigurationAspect)ConfigurationService.getConfigurationAspect(TestConfigurationAspect.class)).getSomeInt()).isEqualTo(6));
        Assertions.assertThat((int)((TestConfigurationAspect)ConfigurationService.getConfigurationAspect(TestConfigurationAspect.class)).getSomeInt()).isEqualTo(-1);
        ConfigurationService.defaultConfiguration(con -> con.configure(TestConfigurationAspect.class, c -> c.withSomeInt(5)));
        Assertions.assertThat((int)((TestConfigurationAspect)ConfigurationService.getConfigurationAspect(TestConfigurationAspect.class)).getSomeInt()).isEqualTo(5);
        ConfigurationService.resetToDefaultDefaults();
        Assertions.assertThat((int)((TestConfigurationAspect)ConfigurationService.getConfigurationAspect(TestConfigurationAspect.class)).getSomeInt()).isEqualTo(-1);
        ConfigurationService.withConfiguration(con -> con.configure(TestConfigurationAspect.class, tc -> tc.withSomeInt(3)), () -> Assertions.assertThat((int)((TestConfigurationAspect)ConfigurationService.getConfigurationAspect(TestConfigurationAspect.class)).getSomeInt()).isEqualTo(3));
        Assertions.assertThat((int)((TestConfigurationAspect)ConfigurationService.getConfigurationAspect(TestConfigurationAspect.class)).getSomeInt()).isEqualTo(-1);
        Configuration before = ConfigurationService.getConfiguration();
        Assertions.assertThat((Iterable)before).isEqualTo((Object)ConfigurationService.getConfiguration());
        ConfigurationService.withAspect((ConfigurationAspect)TestConfigurationAspect.builder().someDouble(1234.0).build(), () -> {
            Assertions.assertThat((double)((TestConfigurationAspect)ConfigurationService.getConfigurationAspect(TestConfigurationAspect.class)).getSomeDouble()).isEqualTo(1234.0);
            Assertions.assertThat((Iterable)before).isNotEqualTo((Object)ConfigurationService.getConfiguration());
        });
    }

    @Test
    public void invalid() {
        Assertions.assertThatThrownBy(() -> ConfigurationService.getConfiguration().toBuilder().aspectDefault(InvalidConfigurationAspect.class)).isInstanceOf(InstantiationException.class);
    }

    @Test
    public void associatedWith() {
        List configurationAspectsAssociatedWith = ConfigurationService.getConfiguration().getConfigurationAspectsAssociatedWith(TestProvider.class);
        Assertions.assertThat((List)configurationAspectsAssociatedWith).hasSize(1);
        Assertions.assertThat((Object)((ConfigurationAspect)configurationAspectsAssociatedWith.get(0))).isInstanceOf(TestConfigurationAspect.class);
    }
}

