/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import lombok.Generated;
import org.meeuw.configuration.Configuration;
import org.meeuw.configuration.ConfigurationAspect;
import org.meeuw.configuration.spi.ToStringProvider;

class ConfigurationPreferences {
    @Generated
    private static final Logger log = Logger.getLogger(ConfigurationPreferences.class.getName());
    private static final Preferences USER_PREFERENCES = Preferences.userNodeForPackage(ConfigurationPreferences.class);

    private ConfigurationPreferences() {
    }

    static void sync() throws BackingStoreException {
        USER_PREFERENCES.flush();
        USER_PREFERENCES.sync();
    }

    static void addPreferenceChangeListener(Configuration.Builder configuration) {
        USER_PREFERENCES.addPreferenceChangeListener(evt -> ConfigurationPreferences.readDefaults(configuration));
    }

    static void storeDefaults(Configuration configuration) {
        for (ConfigurationAspect aspect : configuration) {
            Preferences node = ConfigurationPreferences.node(aspect);
            for (Method m : aspect.getClass().getDeclaredMethods()) {
                if (m.getName().length() <= 3 || !m.getName().startsWith("get") || m.getParameterTypes().length != 0 || Modifier.isStatic(m.getModifiers())) continue;
                String name = m.getName().substring(3);
                Class<?> returnType = m.getReturnType();
                try {
                    Object value = m.invoke((Object)aspect, new Object[0]);
                    ConfigurationPreferences.put(node, name, returnType, value);
                }
                catch (IOException | IllegalAccessException | IllegalStateException | InvocationTargetException e) {
                    log.warning(String.format("%s for %s (%s): %s", m.getDeclaringClass(), m, aspect, e.getMessage()));
                }
            }
            log.fine(() -> "Stored " + USER_PREFERENCES);
        }
    }

    static void readDefaults(Configuration.Builder configuration) {
        Iterator<ConfigurationAspect> iterator = configuration.build().iterator();
        while (iterator.hasNext()) {
            ConfigurationAspect aspect;
            ConfigurationAspect as = aspect = iterator.next();
            Preferences node = ConfigurationPreferences.node(as);
            for (Method m : aspect.getClass().getDeclaredMethods()) {
                if (!m.getName().startsWith("with") || m.getParameterTypes().length != 1) continue;
                String name = m.getName().substring(4);
                Object newValue = null;
                try {
                    Object currentValue = as.getClass().getDeclaredMethod("get" + name, new Class[0]).invoke((Object)as, new Object[0]);
                    newValue = ConfigurationPreferences.get(node, name, m.getParameters()[0].getType(), currentValue);
                    as = (ConfigurationAspect)m.invoke((Object)as, newValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                    log.log(Level.WARNING, "For " + as + "#" + m + "(" + (newValue == null ? "NULL" : newValue.getClass() + " " + newValue) + ")" + e.getClass() + " " + e.getMessage(), e);
                }
            }
            configuration.aspectValue(as);
        }
        log.info(() -> "Read " + USER_PREFERENCES);
    }

    private static Preferences node(ConfigurationAspect aspect) {
        return USER_PREFERENCES.node(aspect.getClass().getCanonicalName());
    }

    static void put(Preferences pref, String key, Class<?> type, Object paramValue) throws IOException {
        if (paramValue == null) {
            pref.remove(key);
        } else if (paramValue instanceof Integer) {
            pref.putInt(key, (Integer)paramValue);
        } else if (paramValue instanceof Long) {
            pref.putLong(key, (Long)paramValue);
        } else if (paramValue instanceof Boolean) {
            pref.putBoolean(key, (Boolean)paramValue);
        } else if (paramValue instanceof Float) {
            pref.putFloat(key, ((Float)paramValue).floatValue());
        } else if (paramValue instanceof Double) {
            pref.putDouble(key, (Double)paramValue);
        } else {
            Optional<String> o = ConfigurationPreferences.toString(paramValue);
            if (o.isPresent()) {
                pref.put(key, o.get());
            } else if (paramValue instanceof Serializable) {
                ConfigurationPreferences.putSerializable(pref, key, (Serializable)paramValue);
            } else {
                throw new IllegalStateException("Don't know how to put " + paramValue);
            }
        }
    }

    static <C> Optional<String> toString(C value) {
        return ConfigurationPreferences.stream().sorted().map(tp -> tp.toString(value).orElse(null)).filter(Objects::nonNull).findFirst();
    }

    static Stream<ToStringProvider> stream() {
        ServiceLoader<ToStringProvider> loader = ServiceLoader.load(ToStringProvider.class);
        ArrayList list = new ArrayList();
        loader.iterator().forEachRemaining(list::add);
        return list.stream();
    }

    static <C> C get(Preferences pref, String key, Class<? extends C> type, C defaultValue) {
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return (C)Integer.valueOf(pref.getInt(key, (Integer)defaultValue));
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return (C)Long.valueOf(pref.getLong(key, (Long)defaultValue));
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return (C)Boolean.valueOf(pref.getBoolean(key, (Boolean)defaultValue));
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return (C)Float.valueOf(pref.getFloat(key, ((Float)defaultValue).floatValue()));
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return (C)Double.valueOf(pref.getDouble(key, (Double)defaultValue));
        }
        String v = pref.get(key, ConfigurationPreferences.toString(defaultValue).orElse(null));
        Optional<Object> o = ConfigurationPreferences.stream().sorted().map(tp -> {
            Object nv = tp.fromString(type, v).orElse(null);
            return nv;
        }).filter(Objects::nonNull).findFirst();
        return (C)o.orElseGet(() -> ConfigurationPreferences.getSerializable(pref, key, defaultValue));
    }

    static void putSerializable(Preferences pref, String key, Serializable paramValue) throws IOException {
        try (ByteArrayOutputStream bo = new ByteArrayOutputStream();
             ObjectOutputStream so = new ObjectOutputStream(bo);){
            so.writeObject(paramValue);
            pref.putByteArray(key, bo.toByteArray());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static <C> C getSerializable(Preferences pref, String key, C defaultValue) {
        byte[] bytes = pref.getByteArray(key, new byte[0]);
        if (bytes.length > 0) {
            try (ByteArrayInputStream bi = new ByteArrayInputStream(bytes);){
                Object object;
                try (ObjectInputStream si = new ObjectInputStream(bi);){
                    object = si.readObject();
                }
                return (C)object;
            }
            catch (IOException | ClassNotFoundException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

