/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.meeuw.configuration.ConfigurationAspect;
import org.meeuw.configuration.ConfigurationException;
import org.meeuw.configuration.ConfigurationService;
import org.meeuw.configuration.FixedSizeMap;

public class Configuration
implements Iterable<ConfigurationAspect> {
    @Generated
    private static final Logger log = Logger.getLogger(Configuration.class.getName());
    final Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> map;

    private Configuration(Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> configuration) {
        this.map = Configuration.immutableCopy(configuration);
    }

    public <E extends ConfigurationAspect> E getAspect(Class<E> clazz) {
        ConfigurationAspect result = this.map.get(clazz);
        if (result == null) {
            throw new ConfigurationException("No configuration aspect with class " + clazz + " registered");
        }
        return (E)result;
    }

    public <E extends ConfigurationAspect, V> V getAspectValue(Class<E> clazz, Function<E, V> getter) {
        return getter.apply(this.getAspect(clazz));
    }

    public <E extends ConfigurationAspect> Configuration with(Class<E> clazz, UnaryOperator<E> config) {
        return this.toBuilder().configure(clazz, config).build();
    }

    public List<ConfigurationAspect> getConfigurationAspectsAssociatedWith(Class<?> clazz) {
        return this.map.values().stream().filter(aspect -> aspect.associatedWith().stream().anyMatch(clazz::isAssignableFrom)).collect(Collectors.toList());
    }

    public Builder toBuilder() {
        FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect> newMap = ConfigurationService.newConfigurationMap();
        newMap.putAll(this.map);
        return new Builder(newMap);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Iterator<ConfigurationAspect> iterator() {
        return this.map.values().iterator();
    }

    private static Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> immutableCopy(Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> configuration) {
        FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect> newMap = ConfigurationService.newConfigurationMap();
        newMap.putAll(configuration);
        return Collections.unmodifiableMap(newMap);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> this$map = this.map;
        Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> other$map = other.map;
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Class<? extends ConfigurationAspect>, ConfigurationAspect> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    public static class Builder {
        private final FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect> configuration;

        public Builder(FixedSizeMap<Class<? extends ConfigurationAspect>, ConfigurationAspect> configuration) {
            this.configuration = configuration;
        }

        Builder() {
            this.configuration = ConfigurationService.newConfigurationMap();
        }

        public <E extends ConfigurationAspect> Builder configure(Class<E> aspect, UnaryOperator<E> configOperator) {
            ConfigurationAspect template = this.configuration.get(aspect);
            ConfigurationAspect newConfig = (ConfigurationAspect)configOperator.apply(template);
            this.configuration.put(aspect, newConfig);
            return this;
        }

        public <E extends ConfigurationAspect> Builder aspectValue(E value) {
            this.configuration.put(value.getClass(), value);
            return this;
        }

        public <E extends ConfigurationAspect> Builder aspectDefault(Class<E> clazz) {
            this.configuration.put(clazz, (ConfigurationAspect)clazz.newInstance());
            return this;
        }

        public Builder defaults() {
            for (Class c : this.configuration.keySet()) {
                this.aspectDefault(c);
            }
            return this;
        }

        public Configuration build() {
            return new Configuration(this.configuration);
        }
    }
}

