/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import lombok.Generated;
import org.meeuw.configuration.Configuration;
import org.meeuw.configuration.ConfigurationAspect;
import org.meeuw.configuration.StringConversionService;

class ConfigurationPreferences {
    @Generated
    private static final Logger log = Logger.getLogger(ConfigurationPreferences.class.getName());
    private static final Preferences USER_PREFERENCES = ConfigurationPreferences.createUserPreferences();

    static Preferences getUserPreferences() {
        return USER_PREFERENCES;
    }

    private static synchronized Preferences createUserPreferences() {
        log.finer("Creating user preferences");
        Preferences userPreferences = null;
        try {
            userPreferences = Preferences.userNodeForPackage(ConfigurationPreferences.class);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e, () -> "fooar:" + e.getClass().getName() + ":" + e.getMessage());
        }
        return userPreferences;
    }

    private ConfigurationPreferences() {
    }

    static void sync() throws BackingStoreException {
        USER_PREFERENCES.flush();
        USER_PREFERENCES.sync();
    }

    static void addPreferenceChangeListener(Configuration.Builder configuration) {
        USER_PREFERENCES.addPreferenceChangeListener(evt -> ConfigurationPreferences.readDefaults(configuration));
    }

    static void storeDefaults(Configuration configuration) {
        for (ConfigurationAspect aspect : configuration) {
            Preferences node = ConfigurationPreferences.node(aspect);
            for (Method m : aspect.getClass().getDeclaredMethods()) {
                if (m.getName().length() <= 3 || !m.getName().startsWith("get") || m.getParameterTypes().length != 0 || Modifier.isStatic(m.getModifiers())) continue;
                String name = m.getName().substring(3);
                try {
                    Object value = m.invoke((Object)aspect, new Object[0]);
                    ConfigurationPreferences.put(node, name, value);
                }
                catch (IOException | IllegalAccessException | IllegalStateException | InvocationTargetException e) {
                    log.warning(String.format("%s for %s (%s): %s", m.getDeclaringClass(), m, aspect, e.getMessage()));
                }
            }
            log.finer(() -> "Stored " + USER_PREFERENCES);
        }
    }

    static void readDefaults(Configuration.Builder configuration) {
        Iterator<ConfigurationAspect> iterator = configuration.build().iterator();
        while (iterator.hasNext()) {
            ConfigurationAspect aspect;
            ConfigurationAspect as = aspect = iterator.next();
            Preferences node = ConfigurationPreferences.node(as);
            for (Method m : aspect.getClass().getDeclaredMethods()) {
                if (!m.getName().startsWith("with") || m.getParameterTypes().length != 1) continue;
                String name = m.getName().substring(4);
                Object newValue = null;
                try {
                    Object currentValue = as.getClass().getDeclaredMethod("get" + name, new Class[0]).invoke((Object)as, new Object[0]);
                    newValue = ConfigurationPreferences.get(node, name, m.getParameters()[0].getType(), currentValue);
                    as = (ConfigurationAspect)m.invoke((Object)as, newValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                    log.log(Level.WARNING, "For " + as + "#" + m + "(" + (newValue == null ? "NULL" : newValue.getClass() + " " + newValue) + ")" + e.getClass() + " " + e.getMessage(), e);
                }
            }
            configuration.aspectValue(as);
        }
        log.fine(() -> "Read " + USER_PREFERENCES);
    }

    private static Preferences node(ConfigurationAspect aspect) {
        return USER_PREFERENCES.node(aspect.getClass().getCanonicalName());
    }

    static void put(Preferences pref, String key, Object paramValue) throws IOException {
        if (paramValue == null) {
            pref.remove(key);
        } else {
            Optional<String> o = StringConversionService.toString(paramValue);
            if (o.isPresent()) {
                pref.put(key, o.get());
            } else if (paramValue instanceof Serializable) {
                ConfigurationPreferences.putSerializable(pref, key, (Serializable)paramValue);
            } else {
                throw new IllegalStateException("Don't know how to put " + paramValue);
            }
        }
    }

    static <C> C get(Preferences pref, String key, Class<? extends C> type, C defaultValue) {
        String v = pref.get(key, StringConversionService.toString(defaultValue).orElse(null));
        Optional<C> o = StringConversionService.fromString(v, type);
        return (C)o.orElseGet(() -> ConfigurationPreferences.getSerializable(pref, key, defaultValue));
    }

    static void putSerializable(Preferences pref, String key, Serializable paramValue) throws IOException {
        try (ByteArrayOutputStream bo = new ByteArrayOutputStream();
             ObjectOutputStream so = new ObjectOutputStream(bo);){
            so.writeObject(paramValue);
            pref.putByteArray(key, bo.toByteArray());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static <C> C getSerializable(Preferences pref, String key, C defaultValue) {
        byte[] bytes = pref.getByteArray(key, new byte[0]);
        if (bytes.length > 0) {
            try (ByteArrayInputStream bi = new ByteArrayInputStream(bytes);){
                Object object;
                try (ObjectInputStream si = new ObjectInputStream(bi);){
                    object = si.readObject();
                }
                return (C)object;
            }
            catch (IOException | ClassNotFoundException e) {
                log.log(Level.WARNING, "For byte array with length " + bytes.length + ":" + e.getClass().getName() + ": " + e.getMessage() + ", defaulting to " + defaultValue, e);
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

