/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;
import java.util.logging.Logger;
import lombok.Generated;

public class ReflectionUtils {
    @Generated
    private static final Logger log = Logger.getLogger(ReflectionUtils.class.getName());

    private ReflectionUtils() {
    }

    public static <C, D> void forConstants(Class<C> clazz, Class<D> constantClass, Consumer<D> consumer) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || !constantClass.isAssignableFrom(f.getType())) continue;
            try {
                consumer.accept(f.get(null));
            }
            catch (IllegalAccessException e) {
                assert (false) : e.getMessage();
            }
        }
    }

    public static <C> void forConstants(Class<C> clazz, Consumer<C> consumer) {
        ReflectionUtils.forConstants(clazz, clazz, consumer);
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... params) {
        return clazz.getDeclaredMethod(name, params);
    }

    public static Method getDeclaredBinaryMethod(Class<?> clazz, String name) {
        return ReflectionUtils.getDeclaredMethod(clazz, name, clazz);
    }
}

