/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.meeuw.configuration.spi.ToStringProvider;

public class StringConversionService {
    private StringConversionService() {
    }

    public static <C> Optional<String> toString(C value) {
        return StringConversionService.stream().sorted().map(tp -> tp.toString(value).orElse(null)).filter(Objects::nonNull).findFirst();
    }

    public static <C> Optional<C> fromString(String value, Class<? extends C> type) {
        return StringConversionService.stream().sorted().map(tp -> tp.fromString(type, value).orElse(null)).filter(Objects::nonNull).findFirst();
    }

    static Stream<ToStringProvider<?>> stream() {
        ServiceLoader<ToStringProvider> loader = ServiceLoader.load(ToStringProvider.class);
        ArrayList list = new ArrayList();
        loader.iterator().forEachRemaining(list::add);
        return list.stream();
    }
}

