/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration.spi;

import java.util.Optional;
import java.util.logging.Logger;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.meeuw.configuration.spi.ToStringProvider;

public class EnumToString
implements ToStringProvider<Enum<?>> {
    @Generated
    private static final Logger log = Logger.getLogger(EnumToString.class.getName());

    @Override
    public int weight() {
        return 0;
    }

    @Override
    public Optional<String> toString(@Nullable Object value) {
        return Optional.ofNullable(value).filter(v -> v instanceof Enum).map(v -> ((Enum)v).name());
    }

    @Override
    public Optional<Enum<?>> fromString(Class<?> type, @Nullable String value) {
        return Optional.ofNullable(value).filter(v -> type.isEnum()).map(v -> {
            try {
                return Enum.valueOf(type, value);
            }
            catch (IllegalArgumentException iae) {
                log.warning(value + "->" + type + ":" + iae.getMessage());
                return null;
            }
        });
    }
}

