/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.configuration.spi;

import java.util.Optional;
import java.util.logging.Logger;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.meeuw.configuration.spi.ToStringProvider;

public abstract class NumberToString<N extends Number>
implements ToStringProvider<N> {
    @Generated
    private static final Logger log = Logger.getLogger(NumberToString.class.getName());
    private final Class<?> primitiveType;
    private final Class<?> boxedType;

    protected NumberToString(Class<?> primitiveType, Class<N> boxedtype) {
        this.primitiveType = primitiveType;
        this.boxedType = boxedtype;
    }

    @Override
    public int weight() {
        return 0;
    }

    @Override
    public Optional<String> toString(@Nullable Object value) {
        return Optional.ofNullable(value).filter(v -> v instanceof Number).map(Object::toString);
    }

    protected abstract N valueOf(String var1);

    @Override
    public Optional<N> fromString(Class<?> type, @Nullable String value) {
        Class<?> finalType = this.toWrapper(type);
        return Optional.ofNullable(value).filter(v -> this.boxedType.isAssignableFrom(finalType)).map(v -> {
            try {
                return this.valueOf(value);
            }
            catch (IllegalArgumentException iae) {
                log.warning(value + "->" + type + ":" + iae.getMessage());
                return null;
            }
        });
    }

    protected Class<?> toWrapper(Class<?> clazz) {
        if (clazz == this.primitiveType) {
            return this.boxedType;
        }
        return clazz;
    }
}

