/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.i18n.openlocationcode;

import com.google.openlocationcode.OpenLocationCode;
import java.util.Comparator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import javax.validation.constraints.Min;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.meeuw.i18n.openlocationcode.OpenLocation;
import org.meeuw.i18n.regions.spi.RegionProvider;

@Priority(value=100)
public class OpenLocationProvider
implements RegionProvider<OpenLocation> {
    private static final Logger logger = Logger.getLogger(OpenLocationProvider.class.getName());
    public static final int CODE_ALPHABET_LENGTH = "23456789CFGHJMPQRVWX".length();
    public static final int CODE_ALPHABET_LENGTH_2 = CODE_ALPHABET_LENGTH * CODE_ALPHABET_LENGTH;
    @Min(value=0L)
    private static @Min(value=0L) int maxLength = 4;

    public static int getMaxLength() {
        return maxLength;
    }

    public static void setMaxLength(int maxLength) {
        OpenLocationProvider.maxLength = maxLength;
    }

    public Optional<OpenLocation> getByCode(@NonNull String code, boolean lenient) {
        try {
            return Optional.of(new OpenLocation(new OpenLocationCode(code)));
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
    }

    public OpenLocation getByCoordinates(double latitude, double longitude) {
        return new OpenLocation(new OpenLocationCode(latitude, longitude));
    }

    public Class<OpenLocation> getProvidedClass() {
        return OpenLocation.class;
    }

    public Stream<OpenLocation> values() {
        return StreamSupport.stream(() -> new OpenLocationCodeSpliterator(), 1281, false).map(a -> new OpenLocation(OpenLocationProvider.toCode(a)));
    }

    public static long limitForLength(@Min(value=0L) @Min(value=0L) int length) {
        if (length == 0) {
            return 0L;
        }
        long result = 162L;
        for (int i = 1; i < length; ++i) {
            result *= (long)CODE_ALPHABET_LENGTH_2;
        }
        return result + OpenLocationProvider.limitForLength(length - 1);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + OpenLocationProvider.limitForLength(maxLength) + " codes in stream)";
    }

    static OpenLocationCode toCode(int[] template) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= template.length / 2 - 1; ++i) {
            builder.append("23456789CFGHJMPQRVWX".charAt(template[2 * i]));
            builder.append("23456789CFGHJMPQRVWX".charAt(template[2 * i + 1]));
            if (builder.length() != 8) continue;
            builder.append('+');
        }
        while (builder.length() < 8) {
            builder.append('0');
        }
        if (builder.length() == 8) {
            builder.append('+');
        }
        return new OpenLocationCode(builder.toString());
    }

    static int[] templateAt(long position) {
        long numberShorter;
        long proposal = numberShorter = 162L;
        int length = 2;
        while (position > proposal) {
            numberShorter = proposal;
            proposal = numberShorter + (long)CODE_ALPHABET_LENGTH_2 * numberShorter;
            length += 2;
        }
        long positionRelative = position - numberShorter;
        int[] template = new int[length];
        OpenLocationProvider.fillTemplate(template, positionRelative);
        return template;
    }

    static void fillTemplate(int[] template, long position) {
        for (int i = template.length - 1; i >= 0; --i) {
            int modulo;
            int max = OpenLocationProvider.getMax(i);
            template[i] = modulo = (int)(position % (long)max);
            position -= (long)modulo;
            position /= (long)max;
        }
    }

    static int[] advance(int[] template, int step, Consumer<int[]> initter) {
        for (int i = template.length - 1; i >= 0; --i) {
            int max = OpenLocationProvider.getMax(i);
            int newValue = template[i] + step;
            template[i] = newValue % max;
            int carry = newValue / max;
            if (carry > 0) {
                step = carry;
                continue;
            }
            return template;
        }
        template = new int[template.length + 2];
        initter.accept(template);
        return template;
    }

    static void advance(int[] template, int step) {
        OpenLocationProvider.advance(template, step, t -> {
            throw new IllegalStateException();
        });
    }

    private static int getMax(int positionInTemplate) {
        if (positionInTemplate == 0) {
            return 9;
        }
        if (positionInTemplate == 1) {
            return 18;
        }
        return CODE_ALPHABET_LENGTH;
    }

    static long position(int[] template) {
        int factor = 1;
        int result = 0;
        for (int i = template.length - 1; i >= 0; --i) {
            int nextExtraFactor = OpenLocationProvider.getMax(i);
            result += template[i] * factor;
            factor *= nextExtraFactor;
        }
        return result;
    }

    private static class OpenLocationCodeSpliterator
    implements Spliterator<int[]> {
        static final int CHARACTERISTICS = 1281;
        static final int maxStep;
        long count = 0L;
        int[] template = new int[2];
        long lastCount = OpenLocationProvider.limitForLength(OpenLocationProvider.access$000());
        int step = 1;
        int loggedAtStep = -1;
        int offset = 0;

        private OpenLocationCodeSpliterator() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super int[]> action) {
            if (this.count > this.lastCount) {
                return false;
            }
            if (logger.isLoggable(Level.FINE) && this.loggedAtStep != this.step) {
                logger.fine("Running in " + Thread.currentThread().getName() + " step: " + this.step + " offset: " + this.offset);
                this.loggedAtStep = this.step;
            }
            action.accept((int[])this.template);
            this.template = OpenLocationProvider.advance(this.template, this.step, t -> OpenLocationProvider.advance(t, this.offset));
            if (this.template.length / 2 > maxLength) {
                return false;
            }
            ++this.count;
            return true;
        }

        @Override
        public @Nullable Spliterator<int[]> trySplit() {
            OpenLocationCodeSpliterator split = new OpenLocationCodeSpliterator();
            if (this.step >= maxStep) {
                return null;
            }
            split.lastCount = this.lastCount;
            split.template = new int[this.template.length];
            System.arraycopy(this.template, 0, split.template, 0, this.template.length);
            split.offset = this.offset + this.step;
            split.template = OpenLocationProvider.advance(split.template, this.step, t -> OpenLocationProvider.advance(split.template, split.offset));
            this.step *= 2;
            split.step = this.step;
            split.count = this.count;
            return split;
        }

        @Override
        public long estimateSize() {
            return (this.lastCount - this.count) / (long)this.step;
        }

        @Override
        public Comparator<? super int[]> getComparator() {
            return new Comparator<int[]>(){

                @Override
                public int compare(int[] a, int[] b) {
                    if (a == b) {
                        return 0;
                    }
                    int max = Math.min(a.length, b.length);
                    for (int i = 0; i < max; ++i) {
                        if (a[i] == b[i]) continue;
                        return Integer.compare(a[i], b[i]);
                    }
                    return a.length - b.length;
                }
            };
        }

        @Override
        public int characteristics() {
            return this.step == 1 ? 1345 : 1281;
        }

        static {
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            maxStep = Math.min(availableProcessors, 8);
        }
    }
}

