/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.jaxbdocumentation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.meeuw.xml.bind.annotation.XmlDocumentation;
import org.xml.sax.SAXException;

public class DocumentationAdder
implements Supplier<Transformer> {
    private static final String URI_FOR_DOCUMENTATIONS = "http://meeuw.org/documentations";
    private static final Map<Class[], Map<String, String>> CACHE = new ConcurrentHashMap<Class[], Map<String, String>>();
    private final Class<?>[] classes;
    private Transformer transformer;
    private boolean useCache = false;

    public DocumentationAdder(Class<?> ... classes) {
        this.classes = classes;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void transform(Source source, Result out) throws TransformerException {
        this.get().transform(source, out);
    }

    public Map<String, Source> schemaSources() throws JAXBException, IOException, SAXException {
        JAXBContext context = JAXBContext.newInstance((Class[])this.classes);
        final HashMap results = new HashMap();
        context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                DOMResult dom = new DOMResult();
                if (namespaceUri != null && namespaceUri.length() > 0) {
                    dom.setSystemId(namespaceUri);
                    results.put(namespaceUri, dom);
                } else {
                    dom.setSystemId(suggestedFileName);
                    results.put(suggestedFileName, dom);
                }
                return dom;
            }
        });
        HashMap<String, Source> sources = new HashMap<String, Source>();
        for (Map.Entry result : results.entrySet()) {
            DOMSource source = new DOMSource(((DOMResult)result.getValue()).getNode());
            sources.put((String)result.getKey(), source);
        }
        return sources;
    }

    public Map<String, Source> transformedSources() throws JAXBException, IOException, SAXException, TransformerException {
        HashMap<String, Source> result = new HashMap<String, Source>();
        for (Map.Entry<String, Source> sourceEntry : this.schemaSources().entrySet()) {
            DOMResult domResult = new DOMResult();
            this.transform(sourceEntry.getValue(), domResult);
            result.put(sourceEntry.getKey(), new DOMSource(domResult.getNode()));
        }
        return result;
    }

    @Override
    public Transformer get() {
        if (this.transformer == null) {
            try {
                TransformerFactory transFact = TransformerFactory.newInstance();
                this.transformer = transFact.newTransformer(new StreamSource(DocumentationAdder.class.getResourceAsStream("/add-documentation.xsd")));
                this.transformer.setURIResolver(new DocumentationResolver(this.createDocumentations(this.classes)));
            }
            catch (IOException | ParserConfigurationException | TransformerConfigurationException | SAXException e) {
                throw new RuntimeException(e);
            }
        }
        return this.transformer;
    }

    protected Map<String, String> createDocumentations(Class<?> ... classes) throws IOException, ParserConfigurationException, SAXException {
        Function<Class[], Map> creator = cc -> {
            CollectContext collectContext = new CollectContext();
            for (Class clazz : cc) {
                DocumentationAdder.handleClass(clazz, collectContext);
            }
            return collectContext.docs;
        };
        if (this.useCache) {
            return CACHE.computeIfAbsent(classes, creator);
        }
        return creator.apply(classes);
    }

    private static void handleClass(Class<?> clazz, CollectContext collectContext) {
        if (clazz.isPrimitive()) {
            return;
        }
        if (clazz.getPackage() != null && clazz.getPackage().getName().startsWith("java.")) {
            return;
        }
        if (collectContext.handled.add(clazz)) {
            XmlAccessType accessType = DocumentationAdder.getAccessType(clazz);
            String parent = DocumentationAdder.handle(clazz.getAnnotations(), null, DocumentationAdder.defaultName(clazz), true, collectContext.docs);
            for (Field field : clazz.getDeclaredFields()) {
                DocumentationAdder.handleField(parent, field, accessType, collectContext);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                DocumentationAdder.handleMethod(parent, (Method)accessibleObject, accessType, collectContext);
            }
            for (Class<?> superClass = clazz.getSuperclass(); superClass != null && superClass.getAnnotation(XmlTransient.class) != null; superClass = superClass.getSuperclass()) {
                XmlAccessType superAccessType = DocumentationAdder.getAccessType(superClass);
                for (Field field : superClass.getDeclaredFields()) {
                    DocumentationAdder.handleField(parent, field, superAccessType, collectContext);
                }
                for (AccessibleObject accessibleObject : superClass.getDeclaredMethods()) {
                    DocumentationAdder.handleMethod(parent, (Method)accessibleObject, superAccessType, collectContext);
                }
            }
        }
    }

    private static XmlAccessType getAccessType(Class<?> clazz) {
        XmlAccessorType accessorType = clazz.getAnnotation(XmlAccessorType.class);
        return accessorType == null ? XmlAccessType.PUBLIC_MEMBER : accessorType.value();
    }

    private static void handleField(String parent, Field field, XmlAccessType accessType, CollectContext collectContext) {
        if (Modifier.isStatic(field.getModifiers())) {
            if (Enum.class.isAssignableFrom(field.getType())) {
                DocumentationAdder.handleEnumValue(parent, field, collectContext);
            }
            return;
        }
        String defaultFieldName = field.getName();
        boolean implicit = false;
        switch (accessType) {
            case PUBLIC_MEMBER: {
                if (!Modifier.isPublic(field.getModifiers())) break;
            }
            case FIELD: {
                implicit = true;
            }
        }
        DocumentationAdder.handle(field.getAnnotations(), parent, defaultFieldName, implicit, collectContext.docs);
        DocumentationAdder.recurseXmlElementAnnotations(DocumentationAdder.collectXmlElements(field.getAnnotation(XmlElement.class), field.getAnnotation(XmlElements.class)), collectContext);
        DocumentationAdder.handleClass(field.getType(), collectContext);
    }

    private static void handleEnumValue(String parent, Field field, CollectContext collectContext) {
        String defaultFieldName = field.getName();
        XmlDocumentation annot = field.getAnnotation(XmlDocumentation.class);
        if (annot != null) {
            String key = DocumentationAdder.name(annot, parent, "ENUMERATION", defaultFieldName);
            collectContext.docs.put(key, annot.value());
        }
    }

    private static void recurseXmlElementAnnotations(Collection<XmlElement> xmlElements, CollectContext collectContext) {
        for (XmlElement xmlElement : xmlElements) {
            if (xmlElement.type() == XmlElement.DEFAULT.class) continue;
            DocumentationAdder.handleClass(xmlElement.type(), collectContext);
        }
    }

    private static List<XmlElement> collectXmlElements(XmlElement xmlElement, XmlElements xmlElements) {
        ArrayList<XmlElement> result = new ArrayList<XmlElement>();
        if (xmlElement != null) {
            result.add(xmlElement);
        }
        if (xmlElements != null) {
            result.addAll(Arrays.asList(xmlElements.value()));
        }
        return result;
    }

    private static void handleMethod(String parent, Method method, XmlAccessType accessType, CollectContext collectContext) {
        if (Modifier.isStatic(method.getModifiers())) {
            return;
        }
        boolean implicit = false;
        switch (accessType) {
            case PUBLIC_MEMBER: {
                if (!Modifier.isPublic(method.getModifiers())) break;
            }
            case PROPERTY: {
                implicit = true;
            }
        }
        String defaultFieldName = DocumentationAdder.defaultName(method);
        DocumentationAdder.handle(method.getAnnotations(), parent, defaultFieldName, implicit, collectContext.docs);
        DocumentationAdder.recurseXmlElementAnnotations(DocumentationAdder.collectXmlElements(method.getAnnotation(XmlElement.class), method.getAnnotation(XmlElements.class)), collectContext);
        DocumentationAdder.handleClass(method.getReturnType(), collectContext);
    }

    private static String defaultName(Class<?> clazz) {
        XmlSchema schema;
        String simpleName = clazz.getSimpleName();
        String name = Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
        String namespace = "";
        Package pack = clazz.getPackage();
        if (pack != null && (schema = pack.getAnnotation(XmlSchema.class)) != null && !"##default".equals(schema.namespace())) {
            namespace = "{" + schema.namespace() + "}";
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!(annotation instanceof XmlType)) continue;
            XmlType xmlType = (XmlType)annotation;
            if (!"##default".equals(xmlType.namespace())) {
                namespace = "{" + xmlType.namespace() + "}";
            }
            if ("##default".equals(xmlType.name())) continue;
            name = xmlType.name();
        }
        return namespace + name;
    }

    private static String defaultName(Field field) {
        return field.getName();
    }

    private static String defaultName(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            return name.substring(3);
        }
        return name;
    }

    private static String handle(Annotation[] annots, String parent, String name, boolean implicit, Map<String, String> docs) {
        XmlDocumentation annot = null;
        String type = "ELEMENT";
        boolean explicit = false;
        for (Annotation a : annots) {
            if (a instanceof XmlDocumentation) {
                annot = (XmlDocumentation)a;
            }
            if (a instanceof XmlTransient) {
                return null;
            }
            if (a instanceof XmlAttribute) {
                explicit = true;
                type = "ATTRIBUTE";
                if (!((XmlAttribute)a).name().equals("##default")) {
                    name = ((XmlAttribute)a).name();
                }
            }
            if (a instanceof XmlElement) {
                explicit = true;
                if (!((XmlElement)a).name().equals("##default")) {
                    name = ((XmlElement)a).name();
                }
            }
            if (!(a instanceof XmlElements)) continue;
            explicit = true;
        }
        if (annot != null && (implicit || explicit)) {
            String result = DocumentationAdder.name(annot, parent, type, name);
            docs.put(result, annot.value());
            return result;
        }
        return null;
    }

    private static String name(XmlDocumentation annot, String parent, String type, String defaultName) {
        String name = annot.name().isEmpty() ? defaultName : annot.name();
        String namespace = annot.namespace().isEmpty() ? "" : "{" + annot.namespace() + "}";
        return (parent == null ? "" : parent + "|" + type + "|") + namespace + name;
    }

    private static StreamSource toDocument(Map<String, String> map) throws IOException, ParserConfigurationException, SAXException {
        Properties properties = new Properties();
        properties.putAll(map);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        properties.storeToXML(stream, null);
        StreamSource source = new StreamSource(new ByteArrayInputStream(stream.toByteArray()));
        return source;
    }

    private static class CollectContext {
        final Map<String, String> docs = new HashMap<String, String>();
        final Set<Object> handled = new HashSet<Object>();

        private CollectContext() {
        }
    }

    private static class DocumentationResolver
    implements URIResolver {
        final Map<String, String> docs;

        private DocumentationResolver(Map<String, String> docs) {
            this.docs = docs;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            if (DocumentationAdder.URI_FOR_DOCUMENTATIONS.equals(href)) {
                try {
                    return DocumentationAdder.toDocument(this.docs);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new TransformerException(e);
                }
            }
            return null;
        }
    }
}

