/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.jaxbdocumentation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.meeuw.jaxbdocumentation.Utils;
import org.meeuw.xml.bind.annotation.XmlDocumentation;
import org.meeuw.xml.bind.annotation.XmlDocumentations;

public class DocumentationAdder
implements Supplier<Transformer> {
    private static final String URI_FOR_DOCUMENTATIONS = "http://meeuw.org/documentations";
    private static final String PARAM_XML_STYLESHEET = "xmlStyleSheet";
    private static final String PARAM_DEBUG = "debug";
    private static final Map<Class<?>[], Map<String, String>> CACHE = new ConcurrentHashMap<Class<?>[], Map<String, String>>();
    private final Class<?>[] classes;
    private Transformer transformer;
    private boolean useCache = false;
    private String xmlStyleSheet = null;
    private boolean debug = false;

    public DocumentationAdder(Class<?> ... classes) {
        this.classes = classes;
    }

    public void transform(Source source, Result out) throws TransformerException {
        this.get().transform(source, out);
    }

    @Override
    public Transformer get() {
        if (this.transformer == null) {
            try {
                TransformerFactory transFact = TransformerFactory.newInstance();
                this.transformer = transFact.newTransformer(new StreamSource(DocumentationAdder.class.getResourceAsStream("/add-documentation.xslt")));
                this.transformer.setURIResolver(new DocumentationResolver(this.createDocumentations(this.classes)));
                if (this.xmlStyleSheet != null) {
                    this.transformer.setParameter(PARAM_XML_STYLESHEET, this.xmlStyleSheet);
                }
                this.transformer.setParameter(PARAM_DEBUG, this.debug);
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.transformer;
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    public void write(Writer writer) throws JAXBException, IOException, TransformerException {
        for (Map.Entry<String, Source> sourceEntry : Utils.schemaSources(this.getClasses()).entrySet()) {
            this.transform(sourceEntry.getValue(), new StreamResult(writer));
        }
    }

    public String write() throws JAXBException, IOException, TransformerException {
        StringWriter writer = new StringWriter();
        this.write(writer);
        return writer.toString();
    }

    protected Map<String, String> createDocumentations(Class<?> ... classes) {
        Function<Class[], Map> creator = cc -> {
            CollectContext collectContext = new CollectContext();
            for (Class clazz : cc) {
                DocumentationAdder.handleClass(clazz, collectContext);
            }
            return collectContext.docs;
        };
        if (this.useCache) {
            return CACHE.computeIfAbsent(classes, creator);
        }
        return creator.apply(classes);
    }

    private static void handleClass(Class<?> clazz, CollectContext collectContext) {
        if (clazz.isPrimitive()) {
            return;
        }
        if (clazz.getPackage() != null && clazz.getPackage().getName().startsWith("java.")) {
            return;
        }
        if (collectContext.handled.add(clazz)) {
            XmlAccessType accessType = DocumentationAdder.getAccessType(clazz);
            @NonNull String parent = DocumentationAdder.handle(clazz.getAnnotation(XmlDocumentation.class), DocumentationAdder.defaultName(clazz), collectContext.docs);
            for (Field field : clazz.getDeclaredFields()) {
                DocumentationAdder.handleField(parent, field, accessType, collectContext);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                DocumentationAdder.handleMethod(parent, (Method)accessibleObject, accessType, collectContext);
            }
            for (Class<?> superClass = clazz.getSuperclass(); superClass != null && superClass.getAnnotation(XmlTransient.class) != null; superClass = superClass.getSuperclass()) {
                XmlAccessType superAccessType = DocumentationAdder.getAccessType(superClass);
                for (Field field : superClass.getDeclaredFields()) {
                    DocumentationAdder.handleField(parent, field, superAccessType, collectContext);
                }
                for (AccessibleObject accessibleObject : superClass.getDeclaredMethods()) {
                    DocumentationAdder.handleMethod(parent, (Method)accessibleObject, superAccessType, collectContext);
                }
            }
        }
    }

    private static XmlAccessType getAccessType(Class<?> clazz) {
        XmlAccessorType accessorType = clazz.getAnnotation(XmlAccessorType.class);
        return accessorType == null ? XmlAccessType.PUBLIC_MEMBER : accessorType.value();
    }

    private static void handleField(@NonNull String parent, Field field, XmlAccessType accessType, CollectContext collectContext) {
        if (Type.isEnum(field).isPresent()) {
            DocumentationAdder.handleEnumValue(parent, field, collectContext);
            return;
        }
        String defaultFieldName = field.getName();
        boolean implicit = false;
        switch (accessType) {
            case PUBLIC_MEMBER: {
                if (!Modifier.isPublic(field.getModifiers())) break;
            }
            case FIELD: {
                implicit = true;
            }
        }
        DocumentationAdder.handleFieldOrMethod(field, parent, defaultFieldName, implicit, collectContext.docs);
        DocumentationAdder.recurseXmlElementAnnotations(DocumentationAdder.collectXmlElements(field.getAnnotation(XmlElement.class), field.getAnnotation(XmlElements.class)), collectContext);
        DocumentationAdder.handleClass(field.getType(), collectContext);
    }

    private static void handleFieldOrMethod(AccessibleObject accessibleObject, String parent, String defaultFieldName, boolean implicit, Map<String, String> docs) {
        Type type = Type.of(accessibleObject);
        switch (type) {
            case ELEMENT: {
                DocumentationAdder.handleElement(accessibleObject, parent, defaultFieldName, implicit, docs);
                break;
            }
            case ATTRIBUTE: {
                DocumentationAdder.handleAttribute(accessibleObject, parent, defaultFieldName, implicit, docs);
                break;
            }
            case TRANSIENT: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static void handleEnumValue(String parent, Field field, CollectContext collectContext) {
        String defaultFieldName = field.getName();
        XmlDocumentation annot = field.getAnnotation(XmlDocumentation.class);
        if (annot != null) {
            String key = DocumentationAdder.name(parent, Type.ENUMERATION, defaultFieldName);
            collectContext.docs.put(key, annot.value());
        }
    }

    private static void recurseXmlElementAnnotations(Collection<XmlElement> xmlElements, CollectContext collectContext) {
        for (XmlElement xmlElement : xmlElements) {
            if (xmlElement.type() == XmlElement.DEFAULT.class) continue;
            DocumentationAdder.handleClass(xmlElement.type(), collectContext);
        }
    }

    private static List<XmlElement> collectXmlElements(XmlElement xmlElement, XmlElements xmlElements) {
        ArrayList<XmlElement> result = new ArrayList<XmlElement>();
        if (xmlElement != null) {
            result.add(xmlElement);
        }
        if (xmlElements != null) {
            result.addAll(Arrays.asList(xmlElements.value()));
        }
        return result;
    }

    private static void handleMethod(String parent, Method method, XmlAccessType accessType, CollectContext collectContext) {
        if (Modifier.isStatic(method.getModifiers())) {
            return;
        }
        boolean implicit = false;
        switch (accessType) {
            case PUBLIC_MEMBER: {
                if (!Modifier.isPublic(method.getModifiers())) break;
            }
            case PROPERTY: {
                implicit = true;
            }
        }
        String defaultFieldName = DocumentationAdder.defaultName(method);
        DocumentationAdder.handleFieldOrMethod(method, parent, defaultFieldName, implicit, collectContext.docs);
        DocumentationAdder.recurseXmlElementAnnotations(DocumentationAdder.collectXmlElements(method.getAnnotation(XmlElement.class), method.getAnnotation(XmlElements.class)), collectContext);
        DocumentationAdder.handleClass(method.getReturnType(), collectContext);
    }

    private static String defaultName(Class<?> clazz) {
        XmlSchema schema;
        String simpleName = clazz.getSimpleName();
        String name = Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
        String namespace = "{}";
        Package pack = clazz.getPackage();
        if (pack != null && (schema = pack.getAnnotation(XmlSchema.class)) != null && !"##default".equals(schema.namespace())) {
            namespace = "{" + schema.namespace() + "}";
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!(annotation instanceof XmlType)) continue;
            XmlType xmlType = (XmlType)annotation;
            if (!"##default".equals(xmlType.namespace())) {
                namespace = "{" + xmlType.namespace() + "}";
            }
            if ("##default".equals(xmlType.name())) continue;
            name = xmlType.name();
        }
        return namespace + name;
    }

    private static String defaultName(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            return name.substring(3);
        }
        return name;
    }

    private static String handle(XmlDocumentation xmlDocumentation, String name, Map<String, String> docs) {
        if (xmlDocumentation != null) {
            docs.put(name, xmlDocumentation.value());
        }
        return name;
    }

    private static void handleElement(AccessibleObject accessibleObject, @NonNull String parent, String name, boolean implicit, Map<String, String> docs) {
        XmlDocumentation annot = accessibleObject.getAnnotation(XmlDocumentation.class);
        XmlDocumentations annots = accessibleObject.getAnnotation(XmlDocumentations.class);
        if (annots != null) {
            annot = Arrays.stream(annots.value()).filter(x -> x.name().equals("")).findFirst().orElse(null);
        }
        if (annot != null || annots != null) {
            boolean explicit = false;
            ArrayList<String> extraNames = new ArrayList<String>();
            for (Annotation a : accessibleObject.getAnnotations()) {
                if (a instanceof XmlElement) {
                    explicit = true;
                    if (!((XmlElement)a).name().equals("##default")) {
                        name = ((XmlElement)a).name();
                    }
                }
                if (!(a instanceof XmlElements)) continue;
                explicit = true;
                for (XmlElement e : ((XmlElements)a).value()) {
                    if (e.name().equals("##default")) continue;
                    extraNames.add(e.name());
                }
            }
            if (implicit || explicit) {
                if (annot != null) {
                    String result = DocumentationAdder.name(parent, Type.ELEMENT, name);
                    docs.put(result, annot.value());
                }
                for (String extraName : extraNames) {
                    XmlDocumentation extraAnnot = annots == null ? annot : Arrays.stream(annots.value()).filter(x -> x.name().equals(extraName)).findFirst().orElse(annot);
                    docs.put(DocumentationAdder.name(parent, Type.ELEMENT, extraName), extraAnnot.value());
                }
            }
        }
    }

    private static void handleAttribute(AccessibleObject accessibleObject, @NonNull String parent, String name, boolean implicit, Map<String, String> docs) {
        XmlDocumentation annot = accessibleObject.getAnnotation(XmlDocumentation.class);
        XmlDocumentations annots = accessibleObject.getAnnotation(XmlDocumentations.class);
        if (annots != null) {
            throw new IllegalStateException("An attribute cannot have multiple xml documentations");
        }
        if (annot != null) {
            XmlAttribute attribute = accessibleObject.getAnnotation(XmlAttribute.class);
            if (!attribute.name().equals("##default")) {
                name = attribute.name();
            }
            String result = DocumentationAdder.name(parent, Type.ATTRIBUTE, name);
            docs.put(result, annot.value());
        }
    }

    private static String name(@NonNull String parent, @NonNull Type type, @NonNull String name) {
        return parent + "|" + (Object)((Object)type) + "|" + name;
    }

    private static StreamSource toDocument(Map<String, String> map) throws IOException {
        Properties properties = new Properties();
        properties.putAll(map);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        properties.storeToXML(stream, null);
        StreamSource source = new StreamSource(new ByteArrayInputStream(stream.toByteArray()));
        return source;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void setXmlStyleSheet(String xmlStyleSheet) {
        this.xmlStyleSheet = xmlStyleSheet;
    }

    public String getXmlStyleSheet() {
        return this.xmlStyleSheet;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private static class CollectContext {
        final Map<String, String> docs = new HashMap<String, String>();
        final Set<Object> handled = new HashSet<Object>();

        private CollectContext() {
        }
    }

    private static class DocumentationResolver
    implements URIResolver {
        final Map<String, String> docs;

        private DocumentationResolver(Map<String, String> docs) {
            this.docs = docs;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            if (DocumentationAdder.URI_FOR_DOCUMENTATIONS.equals(href)) {
                try {
                    return DocumentationAdder.toDocument(this.docs);
                }
                catch (IOException e) {
                    throw new TransformerException(e);
                }
            }
            return null;
        }
    }

    static enum Type {
        ELEMENT,
        ATTRIBUTE,
        ENUMERATION,
        TRANSIENT;


        public static Optional<Type> isEnum(Field field) {
            if (Modifier.isStatic(field.getModifiers()) && Enum.class.isAssignableFrom(field.getType())) {
                return Optional.of(ENUMERATION);
            }
            return Optional.empty();
        }

        public static Type of(AccessibleObject accessibleObject) {
            if (accessibleObject.getAnnotation(XmlTransient.class) != null) {
                return TRANSIENT;
            }
            if (accessibleObject.getAnnotation(XmlAttribute.class) != null) {
                return ATTRIBUTE;
            }
            return ELEMENT;
        }
    }
}

