/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.jaxbdocumentation;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.SchemaOutputResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.meeuw.jaxbdocumentation.DocumentationAdder;
import org.xml.sax.SAXException;

public class Utils {
    public static Map<String, Source> schemaSources(Class<?> ... classes) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])classes);
        final HashMap results = new HashMap();
        context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String namespaceUri, String suggestedFileName) {
                DOMResult dom = new DOMResult();
                if (namespaceUri != null && namespaceUri.length() > 0) {
                    dom.setSystemId(namespaceUri);
                    results.put(namespaceUri, dom);
                } else {
                    dom.setSystemId(suggestedFileName);
                    results.put(suggestedFileName, dom);
                }
                return dom;
            }
        });
        HashMap<String, Source> sources = new HashMap<String, Source>();
        for (Map.Entry result : results.entrySet()) {
            DOMSource source = new DOMSource(((DOMResult)result.getValue()).getNode());
            sources.put((String)result.getKey(), source);
        }
        return sources;
    }

    public static Map<String, Source> documentationSchemaSources(Class<?> ... classes) throws JAXBException, IOException, SAXException, TransformerException {
        DocumentationAdder transformer = new DocumentationAdder(classes);
        transformer.setUseCache(true);
        HashMap<String, Source> result = new HashMap<String, Source>();
        for (Map.Entry<String, Source> sourceEntry : Utils.schemaSources(transformer.getClasses()).entrySet()) {
            DOMResult domResult = new DOMResult();
            transformer.transform(sourceEntry.getValue(), domResult);
            result.put(sourceEntry.getKey(), new DOMSource(domResult.getNode()));
        }
        return result;
    }
}

