/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json;

import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.meeuw.json.JsonIterator;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Util;

public class JsonIteratorTest {
    @Test
    public void test() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"{'a':'b'}"));
        Assertions.assertEquals((Object)"", (Object)iterator.next().getPath().toString());
        Assertions.assertEquals((Object)"a", (Object)iterator.next().getPath().toString());
        Assertions.assertEquals((Object)"a", (Object)iterator.next().getPath().toString());
        Assertions.assertEquals((Object)"", (Object)iterator.next().getPath().toString());
    }

    @Test
    public void test2() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"{'b':[]}"));
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 0);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "b");
        this.assertEvent(iterator.next(), JsonToken.START_ARRAY, 1);
        this.assertEvent(iterator.next(), JsonToken.END_ARRAY, 1);
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 0);
    }

    @Test
    public void testArray() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"[3, 'twee', null]"));
        this.assertEvent(iterator.next(), JsonToken.START_ARRAY, 0);
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 1, "3");
        this.assertEvent(iterator.next(), JsonToken.VALUE_STRING, 1, "twee");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NULL, 1, "null");
        this.assertEvent(iterator.next(), JsonToken.END_ARRAY, 0);
    }

    @Test
    public void testNestedObject() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"{a: {}, c:5}"));
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 0);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "a");
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 1);
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 1);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "c");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 1, "5");
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 0);
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void test3() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"{b: {b1: 5}, c:5, d: [3, 2, {x: 'blabla'}, {y: 'bloebloe'}], e: 'EEE'}"));
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 0);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "b");
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 1);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 2, "b1");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 2, "5");
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 1);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "c");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 1, "5");
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "d");
        this.assertEvent(iterator.next(), JsonToken.START_ARRAY, 1);
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 2, "3");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 2, "2");
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 2);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 3, "x");
        this.assertEvent(iterator.next(), JsonToken.VALUE_STRING, 3, "blabla");
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 2);
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 2);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 3, "y");
        this.assertEvent(iterator.next(), JsonToken.VALUE_STRING, 3, "bloebloe");
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 2);
        this.assertEvent(iterator.next(), JsonToken.END_ARRAY, 1);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "e");
        this.assertEvent(iterator.next(), JsonToken.VALUE_STRING, 1, "EEE");
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 0);
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void collectKeys() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"{a: 1, b: {c: 1, d: 2}}"), path -> path.size() == 1 && path.peekLast().toString().equals("b"), path -> false);
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 0);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "a");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 1, "1");
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "b");
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 1);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 2, "c");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 2, "1");
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 2, "d");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 2, "2");
        ParseEvent last = iterator.next();
        this.assertEvent(last, JsonToken.END_OBJECT, 1);
        Assertions.assertEquals(Arrays.asList("c", "d"), (Object)last.getKeys());
        ParseEvent lastout = iterator.next();
        this.assertEvent(lastout, JsonToken.END_OBJECT, 0);
        Assertions.assertNull((Object)lastout.getKeys());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void collectObjects() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"{a: 1, b: {c: 1, d: {}}}"), path -> false, path -> path != null && path.size() == 1 && path.peekLast().toString().equals("b"));
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 0);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "a");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 1, "1");
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "b");
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 1);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 2, "c");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 2, "1");
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 2, "d");
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 2);
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 2);
        ParseEvent last = iterator.next();
        this.assertEvent(last, JsonToken.END_OBJECT, 1);
        HashMap<String, Serializable> expected = new HashMap<String, Serializable>();
        expected.put("c", Integer.valueOf(1));
        expected.put("d", new HashMap());
        Assertions.assertEquals(expected, (Object)last.getNode());
        ParseEvent lastout = iterator.next();
        this.assertEvent(lastout, JsonToken.END_OBJECT, 0);
        Assertions.assertNull((Object)lastout.getKeys());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void collectArray() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"{a: 1, b: [1, 2.0, 3]}"), path -> false, path -> path != null && path.size() == 1 && path.peekLast().toString().equals("b"));
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 0);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "a");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 1, "1");
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "b");
        this.assertEvent(iterator.next(), JsonToken.START_ARRAY, 1);
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 2, "1");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_FLOAT, 2, "2.0");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 2, "3");
        ParseEvent last = iterator.next();
        this.assertEvent(last, JsonToken.END_ARRAY, 1);
        List<Object> expected = Arrays.asList(1, 2.0, 3);
        Assertions.assertEquals(expected, (Object)last.getNode());
        ParseEvent lastout = iterator.next();
        this.assertEvent(lastout, JsonToken.END_OBJECT, 0);
        Assertions.assertNull((Object)lastout.getKeys());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void collectObjectsMultiple() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"{a: 1, b: {c: 1, d: ['x', 'y']}}"), path -> false, path -> path != null && (path.size() == 1 && path.peekLast().toString().equals("b") || path.size() == 2 && path.peekLast().toString().equals("d")));
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 0);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "a");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 1, "1");
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "b");
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 1);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 2, "c");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 2, "1");
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 2, "d");
        this.assertEvent(iterator.next(), JsonToken.START_ARRAY, 2);
        this.assertEvent(iterator.next(), JsonToken.VALUE_STRING, 3, "x");
        this.assertEvent(iterator.next(), JsonToken.VALUE_STRING, 3, "y");
        ParseEvent endArray = iterator.next();
        this.assertEvent(endArray, JsonToken.END_ARRAY, 2);
        Assertions.assertEquals(Arrays.asList("x", "y"), (Object)endArray.getNode());
        ParseEvent endObject = iterator.next();
        this.assertEvent(endObject, JsonToken.END_OBJECT, 1);
        Assertions.assertEquals((Object)"{c=1, d=[x, y]}", (Object)endObject.getNode().toString());
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 0);
    }

    @Test
    public void array() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"{ \"items\":[{\"a\":'x'}]}"));
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 0);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "items");
        this.assertEvent(iterator.next(), JsonToken.START_ARRAY, 1);
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 2);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 3, "a");
        this.assertEvent(iterator.next(), JsonToken.VALUE_STRING, 3, "x");
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 2);
        this.assertEvent(iterator.next(), JsonToken.END_ARRAY, 1);
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 0);
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void arrayInArray() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"{ \"items\":[{\"a\":[], \"b\": 'B'}]}"));
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 0);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "items");
        this.assertEvent(iterator.next(), JsonToken.START_ARRAY, 1);
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 2);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 3, "a");
        this.assertEvent(iterator.next(), JsonToken.START_ARRAY, 3);
        this.assertEvent(iterator.next(), JsonToken.END_ARRAY, 3);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 3, "b");
        this.assertEvent(iterator.next(), JsonToken.VALUE_STRING, 3, "B");
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 2);
        this.assertEvent(iterator.next(), JsonToken.END_ARRAY, 1);
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 0);
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void npe() throws IOException {
        JsonIterator iterator = new JsonIterator(Util.getJsonParser((String)"{\"items\" : [{ \"result\" : {\"a\" : {}, \"b\" : 1 }} ]}"), path -> false, path -> false);
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 0);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 1, "items");
        this.assertEvent(iterator.next(), JsonToken.START_ARRAY, 1);
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 2);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 3, "result");
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 3);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 4, "a");
        this.assertEvent(iterator.next(), JsonToken.START_OBJECT, 4);
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 4);
        this.assertEvent(iterator.next(), JsonToken.FIELD_NAME, 4, "b");
        this.assertEvent(iterator.next(), JsonToken.VALUE_NUMBER_INT, 4);
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 3);
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 2);
        this.assertEvent(iterator.next(), JsonToken.END_ARRAY, 1);
        this.assertEvent(iterator.next(), JsonToken.END_OBJECT, 0);
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    protected void assertEvent(ParseEvent event, JsonToken token, int depth, String value) {
        Assertions.assertSame((Object)event.getToken(), (Object)token);
        Assertions.assertEquals((int)depth, (int)event.getPath().size());
        Assertions.assertEquals((Object)value, (Object)event.getValue());
    }

    protected void assertEvent(ParseEvent event, JsonToken token, int depth) {
        Assertions.assertEquals((Object)token, (Object)event.getToken());
        Assertions.assertEquals((int)depth, (int)event.getPath().size());
    }
}

