/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.meeuw.json.Structure;

public class StructureTest {
    @Test
    public void test() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Structure structure = new Structure((OutputStream)out);
        structure.read((Reader)new StringReader("{b: {b1: 5}, c:5, d: [3, 2, {x: 'blabla'}, {y: 'bloebloe'}], e: 'EEE'}"));
        String[] result = out.toString().split("\n");
        Assertions.assertEquals((Object)"b.b1", (Object)result[0]);
        Assertions.assertEquals((Object)"c", (Object)result[1]);
        Assertions.assertEquals((Object)"d[0]", (Object)result[2]);
        Assertions.assertEquals((Object)"d[1]", (Object)result[3]);
        Assertions.assertEquals((Object)"d[2].x", (Object)result[4]);
        Assertions.assertEquals((Object)"d[3].y", (Object)result[5]);
        Assertions.assertEquals((Object)"e", (Object)result[6]);
    }

    @Test
    public void testArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Structure structure = new Structure((OutputStream)out);
        structure.read((Reader)new StringReader("{d: [{x: 'blabla'}, {y: 'bloebloe'}], e: 'bla'}"));
        String[] result = out.toString().split("\n");
        Assertions.assertEquals((Object)"d[0].x", (Object)result[0]);
        Assertions.assertEquals((Object)"d[1].y", (Object)result[1]);
        Assertions.assertEquals((Object)"e", (Object)result[2]);
    }

    @Test
    public void testArrayInArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Structure structure = new Structure((OutputStream)out);
        structure.read((Reader)new StringReader("{ \"items\" : [ { \"a\":['A']}]}"));
        String[] result = out.toString().split("\n");
        Assertions.assertEquals((Object)"items[0].a[0]", (Object)result[0]);
    }
}

