/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class Util {
    private Util() {
    }

    public static JsonParser getJsonParser(InputStream in) throws IOException {
        JsonParser jp = Util.getJsonFactory().createParser(in);
        Util.setJsonParserOptions(jp);
        return jp;
    }

    public static JsonParser getJsonParser(Reader in) throws IOException {
        JsonParser jp = Util.getJsonFactory().createParser(in);
        Util.setJsonParserOptions(jp);
        return jp;
    }

    public static JsonParser getJsonParser(String string) throws IOException {
        return Util.getJsonParser(new StringReader(string));
    }

    public static void write(Object map, Writer writer) {
        try {
            JsonGenerator gen = Util.getJsonFactory().createGenerator(writer);
            Util.write(map, gen);
            gen.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    public static void write(Map<String, Object> map, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            gen.writeFieldName(e.getKey());
            Util.write(e.getValue(), gen);
        }
        gen.writeEndObject();
    }

    private static void write(List<Object> os, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        for (Object o : os) {
            Util.write(o, gen);
        }
        gen.writeEndArray();
    }

    private static void write(Object o, JsonGenerator gen) throws IOException {
        if (o == null) {
            gen.writeNull();
        } else if (o instanceof Long) {
            gen.writeNumber(((Long)o).longValue());
        } else if (o instanceof Double) {
            gen.writeNumber(((Double)o).doubleValue());
        } else if (o instanceof Boolean) {
            gen.writeBoolean(((Boolean)o).booleanValue());
        } else if (o instanceof String) {
            gen.writeString((String)o);
        } else if (o instanceof Float) {
            gen.writeNumber(((Float)o).floatValue());
        } else if (o instanceof Integer) {
            gen.writeNumber(((Integer)o).intValue());
        } else if (o instanceof Map) {
            Util.write((Map)o, gen);
        } else if (o instanceof List) {
            Util.write((List)o, gen);
        }
    }

    private static File getFile(String string) {
        if ("-".equals(string) || string == null) {
            return null;
        }
        return new File(string);
    }

    public static InputStream getInput(String[] argv, int pos) throws IOException {
        String arg = argv.length > pos ? argv[pos] : null;
        File file = Util.getFile(arg);
        InputStream in = file == null ? System.in : (!file.exists() ? new URL(arg).openStream() : new FileInputStream(file));
        return in;
    }

    public static OutputStream getOutput(String[] argv, int pos) throws IOException {
        if (argv.length > pos) {
            File file = Util.getFile(argv[pos]);
            return file == null ? System.out : new FileOutputStream(file);
        }
        return System.out;
    }

    protected static void setJsonParserOptions(JsonParser jp) {
        jp.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        jp.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        jp.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        jp.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }

    protected static JsonFactory getJsonFactory() {
        return new JsonFactory();
    }
}

