/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json;

import com.fasterxml.jackson.core.JsonParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import org.meeuw.json.JsonIterator;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Util;

public abstract class AbstractJsonReader
implements Closeable {
    public void read(JsonParser jp) throws IOException {
        JsonIterator i = new JsonIterator(jp);
        while (i.hasNext()) {
            ParseEvent event = i.next();
            this.handleToken(event);
        }
        this.ready();
    }

    public void read(Reader reader) throws IOException {
        this.read(Util.getJsonParser(reader));
    }

    protected abstract void handleToken(ParseEvent var1) throws IOException;

    protected void ready() throws IOException {
    }

    @Override
    public void close() {
        this.ready();
    }
}

