/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.meeuw.json.Path;
import org.meeuw.json.Util;

public class ParseEvent {
    private final JsonToken token;
    private final Path path;
    private final String value;
    private final List<String> keys;
    private final Object node;

    public ParseEvent(JsonToken token, Path path, String value) {
        this(token, path, value, null);
    }

    public ParseEvent(JsonToken token, Path path, String value, List<String> keys) {
        this(token, path, value, keys, null);
    }

    public ParseEvent(JsonToken token, Path path, String value, List<String> keys, Object node) {
        this.token = token;
        this.path = path;
        this.value = value;
        this.keys = keys;
        this.node = node;
    }

    public List<String> getKeys() {
        return this.keys == null ? null : Collections.unmodifiableList(this.keys);
    }

    public String toString() {
        return (Object)((Object)this.token) + " " + this.path + "=" + this.value;
    }

    public void toGenerator(JsonGenerator generator) throws IOException {
        switch (this.getToken()) {
            case START_OBJECT: {
                generator.writeStartObject();
                break;
            }
            case END_OBJECT: {
                generator.writeEndObject();
                break;
            }
            case START_ARRAY: {
                generator.writeStartArray();
                break;
            }
            case END_ARRAY: {
                generator.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                generator.writeFieldName(this.getValue());
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                generator.writeObject(this.getValue());
                break;
            }
            case VALUE_STRING: {
                generator.writeString(this.getValue());
                break;
            }
            case VALUE_NUMBER_INT: {
                generator.writeNumber(this.getValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                generator.writeNumber(this.getValue());
                break;
            }
            case VALUE_TRUE: {
                generator.writeBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                generator.writeBoolean(false);
                break;
            }
            case VALUE_NULL: {
                generator.writeNull();
            }
        }
    }

    public String valueOrNodeAsString() {
        switch (this.getToken()) {
            case END_OBJECT: 
            case END_ARRAY: {
                StringWriter writer = new StringWriter();
                Util.write(this.getNode(), writer);
                return writer.toString();
            }
        }
        return this.getValue();
    }

    public String valueOrNodeAsConciseString() {
        switch (this.getToken()) {
            case END_OBJECT: {
                return "{...}";
            }
            case END_ARRAY: {
                return "[...]";
            }
        }
        return this.getValue();
    }

    @Generated
    public JsonToken getToken() {
        return this.token;
    }

    @Generated
    public Path getPath() {
        return this.path;
    }

    @Generated
    public ParseEvent withValue(String value) {
        return this.value == value ? this : new ParseEvent(this.token, this.path, value, this.keys, this.node);
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Object getNode() {
        return this.node;
    }
}

