/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.meeuw.json.ArrayEntry;
import org.meeuw.json.PathEntry;

public class Path
extends AbstractList<PathEntry> {
    private final List<PathEntry> backing = new ArrayList<PathEntry>();

    public Path() {
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public PathEntry get(int index) {
        return this.backing.get(index);
    }

    @Override
    public PathEntry set(int i, PathEntry e) {
        return this.backing.set(i, e);
    }

    @Override
    public void add(int i, PathEntry e) {
        this.backing.add(i, e);
    }

    @Override
    public PathEntry remove(int i) {
        return this.backing.remove(i);
    }

    public Path(Path copy) {
        this.backing.addAll(copy.backing);
    }

    public Path(PathEntry ... entries) {
        this.backing.addAll(Arrays.asList(entries));
    }

    public Path parent() {
        if (this.size() > 1) {
            PathEntry[] parent = new PathEntry[this.size() - 1];
            Iterator it = this.iterator();
            for (int i = 0; i < this.size() - 1; ++i) {
                parent[i] = (PathEntry)it.next();
            }
            return new Path(parent);
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (PathEntry pe : this) {
            pe.appendTo(builder);
        }
        return builder.toString();
    }

    public PathEntry peekLast() {
        return this.backing.size() == 0 ? null : this.backing.get(this.backing.size() - 1);
    }

    public PathEntry pollLast() {
        return this.backing.size() == 0 ? null : this.backing.remove(this.backing.size() - 1);
    }

    @Override
    public void addLast(ArrayEntry inc) {
        this.backing.add(inc);
    }
}

