/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.meeuw.json.AbstractJsonReader;
import org.meeuw.json.MainUtil;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Util;

public class Formatter
extends AbstractJsonReader {
    final JsonGenerator generator;

    public Formatter(OutputStream out) throws IOException {
        this.generator = Util.getJsonFactory().createGenerator(out);
        this.generator.setPrettyPrinter(new DefaultPrettyPrinter());
    }

    @Override
    protected void handleToken(ParseEvent event) throws IOException {
        event.toGenerator(this.generator);
    }

    @Override
    protected void ready() throws IOException {
        this.generator.close();
    }

    public static void main(String[] argv) throws IOException, ParseException {
        CommandLine cl = MainUtil.commandLine("jsonformat", "[<INPUT FILE>|-] [<OUTPUT FILE>|-]", options -> {}, 0, argv);
        String[] args = cl.getArgs();
        try (InputStream in = Util.getInput(args, 0);
             OutputStream out = Util.getOutput(args, 1);){
            Formatter formatter = new Formatter(out);
            formatter.read(Util.getJsonParser(in));
        }
    }
}

