/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class MaxOffsetIterator<T>
implements Iterator<T> {
    private final Iterator<T> wrapped;
    private final long offsetmax;
    private final long offset;
    private final boolean countNulls;
    private long count = 0L;
    private Boolean hasNext = null;
    private T next;
    private Runnable callback;

    public MaxOffsetIterator(Iterator<T> wrapped, Number max, boolean countNulls) {
        this(wrapped, max, 0L, countNulls);
    }

    public MaxOffsetIterator(Iterator<T> wrapped, Number max) {
        this(wrapped, max, 0L, true);
    }

    public MaxOffsetIterator(Iterator<T> wrapped, Number max, Number offset) {
        this(wrapped, max, offset, true);
    }

    public MaxOffsetIterator(Iterator<T> wrapped, Number max, Number offset, boolean countNulls) {
        this.wrapped = wrapped;
        this.offset = offset == null ? 0L : offset.longValue();
        this.offsetmax = max == null ? Long.MAX_VALUE : max.longValue() + this.offset;
        this.countNulls = countNulls;
    }

    public MaxOffsetIterator<T> callBack(Runnable run) {
        this.callback = run;
        return this;
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.hasNext;
    }

    @Override
    public T next() {
        this.findNext();
        if (!this.hasNext.booleanValue()) {
            throw new NoSuchElementException();
        }
        this.hasNext = null;
        return this.next;
    }

    protected void findNext() {
        if (this.hasNext == null) {
            this.hasNext = false;
            while (this.count < this.offset && this.wrapped.hasNext()) {
                T n = this.wrapped.next();
                if (!this.countNulls && n == null) continue;
                ++this.count;
            }
            if (this.count < this.offsetmax && this.wrapped.hasNext()) {
                this.next = this.wrapped.next();
                if (this.countNulls || this.next != null) {
                    ++this.count;
                }
                this.hasNext = true;
            }
            if (!this.hasNext.booleanValue() && this.callback != null) {
                this.callback.run();
            }
        }
    }

    @Override
    public void remove() {
        this.wrapped.remove();
    }
}

