/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.util;

import org.meeuw.util.Predicate;

public class Predicates {
    private Predicates() {
    }

    public static <S> Predicate<S> alwaysFalse() {
        return new Predicate<S>(){

            @Override
            public boolean test(S t) {
                return false;
            }
        };
    }

    public static <S> Predicate<S> alwaysTrue() {
        return new Predicate<S>(){

            @Override
            public boolean test(S t) {
                return true;
            }
        };
    }

    public static <S> Predicate<S> and(final Predicate<S> ... predicates) {
        return new Predicate<S>(){

            @Override
            public boolean test(S t) {
                for (Predicate p : predicates) {
                    if (p.test(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <S> Predicate<S> or(final Predicate<S> ... predicates) {
        return new Predicate<S>(){

            @Override
            public boolean test(S t) {
                for (Predicate p : predicates) {
                    if (!p.test(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

