/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.meeuw.json.AbstractJsonReader;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Util;
import org.meeuw.util.Manifests;

public class Formatter
extends AbstractJsonReader {
    final JsonGenerator generator;

    public Formatter(OutputStream out) throws IOException {
        this.generator = Util.getJsonFactory().createGenerator(out);
        this.generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
    }

    protected void handleToken(ParseEvent event) throws IOException {
        switch (event.getToken()) {
            case START_OBJECT: {
                this.generator.writeStartObject();
                break;
            }
            case END_OBJECT: {
                this.generator.writeEndObject();
                break;
            }
            case START_ARRAY: {
                this.generator.writeStartArray();
                break;
            }
            case END_ARRAY: {
                this.generator.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                this.generator.writeFieldName(event.getValue());
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                this.generator.writeObject((Object)event.getValue());
                break;
            }
            case VALUE_STRING: {
                this.generator.writeString(event.getValue());
                break;
            }
            case VALUE_NUMBER_INT: {
                this.generator.writeNumber(event.getValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                this.generator.writeNumber(event.getValue());
                break;
            }
            case VALUE_TRUE: {
                this.generator.writeBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                this.generator.writeBoolean(false);
                break;
            }
            case VALUE_NULL: {
                this.generator.writeNull();
            }
        }
    }

    protected void ready() throws IOException {
        this.generator.close();
    }

    public static String version() throws IOException {
        return Manifests.read((String)"ProjectVersion");
    }

    public static void main(String[] argv) throws IOException, ParseException {
        BasicParser parser = new BasicParser();
        Options options = new Options().addOption(new Option("help", "print this message"));
        options.addOption(new Option("version", false, "Output version"));
        CommandLine cl = parser.parse(options, argv, true);
        String[] args = cl.getArgs();
        if (cl.hasOption("version")) {
            System.out.println(Formatter.version());
            System.exit(1);
        }
        if (cl.hasOption("help")) {
            System.out.println("jsonformat - " + Formatter.version() + " - See https://github.com/mihxil/json");
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("jsonformat [OPTIONS]  [<INPUT FILE>|-] [<OUTPUT FILE>|-]", options);
            System.exit(1);
        }
        InputStream in = Util.getInput((String[])args, (int)0);
        OutputStream out = Util.getOutput((String[])args, (int)1);
        Formatter formatter = new Formatter(out);
        formatter.read(Util.getJsonParser((InputStream)in));
        in.close();
        out.close();
    }
}

