/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.meeuw.json.MainUtil;
import org.meeuw.json.Util;
import org.meeuw.json.grep.Sed;
import org.meeuw.json.grep.matching.PathMatcher;
import org.meeuw.json.grep.parsing.Parser;

public class SedMain {
    private final PathMatcher matcher;

    public SedMain(PathMatcher pathMatcher) {
        this.matcher = pathMatcher;
    }

    public static void main(String[] argv) throws IOException, ParseException {
        CommandLine cl = MainUtil.commandLine("jsonsed", "<pathMatcher expression> [<INPUT FILE>|-] [<OUTPUT FILE>|-]", options -> {
            options.addOption(new Option("f", "format", false, "Pretty print output"));
            MainUtil.ignoreArrays(options);
            MainUtil.debug(options);
        }, 1, argv);
        String[] args = cl.getArgs();
        List<String> argList = cl.getArgList();
        boolean ignoreArrays = cl.hasOption("ignoreArrays");
        SedMain main = new SedMain(Parser.parsePathMatcherChain(args[0], ignoreArrays, false, null));
        if (cl.hasOption("debug")) {
            System.out.println(main.matcher);
            System.exit(0);
            return;
        }
        try (InputStream in = Util.getInput(argList.toArray(new String[0]), 1);
             OutputStream out = Util.getOutput(argList.toArray(new String[0]), 2);){
            main.read(in, out, generator -> {
                if (cl.hasOption("format")) {
                    generator.setPrettyPrinter(new DefaultPrettyPrinter());
                }
            });
        }
        System.exit(0);
    }

    private void read(InputStream in, OutputStream out, Consumer<JsonGenerator> jsonGeneratorConsumer) throws IOException {
        Sed sed = new Sed(this.matcher, Util.getJsonParser(in));
        try (JsonGenerator generator = Util.getJsonFactory().createGenerator(out);){
            jsonGeneratorConsumer.accept(generator);
            sed.toGenerator(generator);
        }
    }
}

