/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep.matching;

import java.util.Map;
import java.util.function.Predicate;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Path;
import org.meeuw.json.grep.matching.ObjectMatcher;
import org.meeuw.json.grep.matching.PathMatcher;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJSON;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptMatcher
extends ObjectMatcher {
    final String script;
    final ScriptEngine engine;

    public JavascriptMatcher(String script) {
        this.script = script;
        ScriptEngineManager mgr = new ScriptEngineManager();
        this.engine = mgr.getEngineByName("JavaScript");
    }

    @Override
    protected PathMatcher.MatchResult matchesObject(ParseEvent event) {
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        Scriptable that = context.newObject(scope);
        Function fct = context.compileFunction(scope, this.script, "script", 1, null);
        IdScriptableObject nobj = this.getNativeObject(event);
        Object result = fct.call(context, scope, that, new Object[]{nobj});
        if (!(result instanceof Boolean)) {
            throw new IllegalArgumentException("" + NativeJSON.stringify(context, scope, result, null, null) + " is not a boolean. Called on " + NativeJSON.stringify(context, scope, nobj, null, null));
        }
        return new PathMatcher.MatchResult(event, (Boolean)result);
    }

    private IdScriptableObject getNativeObject(ParseEvent event) {
        if (event.getNode() != null) {
            if (event.getNode() instanceof Map) {
                NativeObject nobj = new NativeObject();
                Map node = (Map)event.getNode();
                for (Map.Entry entry : node.entrySet()) {
                    nobj.defineProperty((String)entry.getKey(), entry.getValue(), 1);
                }
                return nobj;
            }
            return new NativeArray((Object[])event.getNode());
        }
        throw new IllegalStateException("No node found in " + event);
    }

    @Override
    public Predicate<Path> needsKeyCollection() {
        return path -> false;
    }

    @Override
    public Predicate<Path> needsObjectCollection() {
        return path -> true;
    }

    public String toString() {
        return this.script;
    }
}

