/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep.matching;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Path;
import org.meeuw.json.grep.matching.PathMatcher;

public class PathMatcherAndChain
implements PathMatcher {
    private final PathMatcher[] matchers;

    public PathMatcherAndChain(PathMatcher ... matchers) {
        this.matchers = matchers;
    }

    @Override
    public PathMatcher.MatchResult matches(ParseEvent event) {
        for (PathMatcher matcher : this.matchers) {
            PathMatcher.MatchResult matches = matcher.matches(event);
            if (!matches.getAsBoolean()) {
                return PathMatcher.MatchResult.NO;
            }
            event = matches.getEvent();
        }
        return new PathMatcher.MatchResult(event, true);
    }

    @Override
    public Predicate<Path> needsKeyCollection() {
        return path -> Arrays.stream(this.matchers).allMatch(m -> m.needsKeyCollection().test((Path)path));
    }

    @Override
    public Predicate<Path> needsObjectCollection() {
        return path -> Arrays.stream(this.matchers).allMatch(m -> m.needsObjectCollection().test((Path)path));
    }

    public PathMatcher[] getPatterns() {
        return this.matchers;
    }

    public String toString() {
        return Arrays.stream(this.matchers).map(Object::toString).collect(Collectors.joining(" AND "));
    }
}

