/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep.matching;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.grep.matching.PathMatcher;
import org.meeuw.json.grep.matching.ScalarMatcher;

public class ScalarRegexpMatcher
extends ScalarMatcher {
    private final Pattern pattern;
    private final String replacement;

    public ScalarRegexpMatcher(Pattern pattern, String replacement) {
        this.pattern = pattern;
        this.replacement = replacement;
    }

    @Override
    protected PathMatcher.MatchResult matchesScalar(ParseEvent event) {
        Matcher matcher = this.pattern.matcher(event.getValue());
        if (matcher.matches()) {
            if (this.replacement != null) {
                String v = matcher.replaceAll(this.replacement);
                return new PathMatcher.MatchResult(event.withValue(v), true);
            }
            return new PathMatcher.MatchResult(event, true);
        }
        return PathMatcher.MatchResult.NO;
    }

    public String toString() {
        return "value~" + this.pattern;
    }
}

