/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep;

import com.fasterxml.jackson.core.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.meeuw.json.MainUtil;
import org.meeuw.json.Util;
import org.meeuw.json.grep.GrepEvent;
import org.meeuw.json.grep.GrepMainIterator;
import org.meeuw.json.grep.GrepMainIteratorImpl;
import org.meeuw.json.grep.GrepMainRecord;
import org.meeuw.json.grep.matching.PathMatcher;
import org.meeuw.json.grep.parsing.Parser;
import org.meeuw.util.Manifests;
import org.meeuw.util.MaxOffsetIterator;

public class GrepMain {
    Output outputFormat = Output.PATHANDVALUE;
    private String sep = "\n";
    private String recordsep = "\n";
    private final PathMatcher matcher;
    PathMatcher recordMatcher;
    boolean sortFields = true;
    private Long max = null;
    private Long previousMaxRecordSize = null;

    public GrepMain(PathMatcher pathMatcher) {
        this.matcher = pathMatcher;
    }

    public GrepMainIterator iterate(JsonParser in) {
        final GrepMainIteratorImpl wrapped = new GrepMainIteratorImpl(this, in);
        MaxOffsetIterator maxoffset = new MaxOffsetIterator((Iterator)wrapped, (Number)this.max);
        return new GrepMainIterator((Iterator)maxoffset){
            final /* synthetic */ Iterator val$maxoffset;
            {
                this.val$maxoffset = iterator;
            }

            @Override
            public long getMaxRecordSize() {
                return wrapped.getMaxRecordSize();
            }

            @Override
            public boolean hasNext() {
                return this.val$maxoffset.hasNext();
            }

            @Override
            public GrepMainRecord next() {
                return (GrepMainRecord)this.val$maxoffset.next();
            }
        };
    }

    public <T extends OutputStream> T read(JsonParser in, T out) throws IOException {
        PrintStream output = new PrintStream(out);
        GrepMainIterator iterator = this.iterate(in);
        iterator.forEachRemaining(record -> {
            output.print(record.toString());
            output.print(this.recordsep);
        });
        output.close();
        this.previousMaxRecordSize = iterator.getMaxRecordSize();
        return out;
    }

    public Long getPreviousMaxRecordSize() {
        return this.previousMaxRecordSize;
    }

    public <T extends OutputStream> T read(Reader in, T out) throws IOException {
        return this.read(Util.getJsonParser((Reader)in), out);
    }

    public <T extends OutputStream> T read(InputStream in, T out) throws IOException {
        return this.read(Util.getJsonParser((InputStream)in), out);
    }

    public String read(Reader in) throws IOException {
        return this.read(Util.getJsonParser((Reader)in), new ByteArrayOutputStream()).toString();
    }

    public String read(InputStream in) throws IOException {
        return this.read(Util.getJsonParser((InputStream)in), new ByteArrayOutputStream()).toString();
    }

    public Iterator<GrepMainRecord> iterate(InputStream in) {
        return this.iterate(Util.getJsonParser((InputStream)in));
    }

    public static String version() throws IOException {
        return Manifests.read((String)"ProjectVersion");
    }

    public static void main(String[] argv) throws IOException, ParseException {
        CommandLine cl = MainUtil.commandLine((String)"jsongrep", (String)"<pathMatcher expression> [<INPUT FILE>|-]", options -> {
            options.addOption(new Option("o", "output", true, "Output format, one of " + Arrays.asList(Output.values())));
            options.addOption(new Option("s", "sep", true, "Separator (defaults to newline)"));
            options.addOption(new Option("r", "record", true, "Record pattern (default to no matching at all). On match, a record separator will be outputted."));
            options.addOption(new Option("rs", "recordsep", true, "Record separator"));
            options.addOption(new Option("sf", "sortfields", true, "Sort the fields of a found 'record', according to the order of the matchers."));
            options.addOption(new Option("m", "max", false, "Max number of records"));
            MainUtil.ignoreArrays((Options)options);
            MainUtil.debug((Options)options);
        }, (int)1, (String[])argv);
        String[] args = cl.getArgs();
        List argList = cl.getArgList();
        boolean ignoreArrays = cl.hasOption("ignoreArrays");
        Output output = Output.PATHANDVALUE;
        if (cl.hasOption("output")) {
            output = Output.valueOf(cl.getOptionValue("output").toUpperCase());
        }
        String record = null;
        if (cl.hasOption("record")) {
            record = cl.getOptionValue("record");
        }
        GrepMain main = new GrepMain(Parser.parsePathMatcherChain(args[0], ignoreArrays, output.needsObject(), record));
        main.setOutputFormat(output);
        if (cl.hasOption("sep")) {
            main.setSep(cl.getOptionValue("sep"));
        }
        if (cl.hasOption("recordsep")) {
            main.setRecordsep(cl.getOptionValue("recordsep"));
        }
        if (record != null) {
            main.setRecordMatcher(Parser.parsePathMatcherChain(record));
        }
        if (cl.hasOption("sortfields")) {
            main.setSortFields(Boolean.parseBoolean(cl.getOptionValue("sortfields")));
        }
        if (cl.hasOption("max")) {
            main.setMax(Long.valueOf(cl.getOptionValue("max")));
        }
        if (cl.hasOption("debug")) {
            System.out.println(main.matcher);
            System.exit(0);
            return;
        }
        try (InputStream in = Util.getInput((String[])argList.toArray(new String[0]), (int)1);){
            main.read(in, System.out);
        }
        System.exit(0);
    }

    @Generated
    public Output getOutputFormat() {
        return this.outputFormat;
    }

    @Generated
    public void setOutputFormat(Output outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Generated
    public void setSep(String sep) {
        this.sep = sep;
    }

    @Generated
    public String getSep() {
        return this.sep;
    }

    @Generated
    public void setRecordsep(String recordsep) {
        this.recordsep = recordsep;
    }

    @Generated
    public String getRecordsep() {
        return this.recordsep;
    }

    @Generated
    public PathMatcher getMatcher() {
        return this.matcher;
    }

    @Generated
    public PathMatcher getRecordMatcher() {
        return this.recordMatcher;
    }

    @Generated
    public void setRecordMatcher(PathMatcher recordMatcher) {
        this.recordMatcher = recordMatcher;
    }

    @Generated
    public void setSortFields(boolean sortFields) {
        this.sortFields = sortFields;
    }

    @Generated
    public void setMax(Long max) {
        this.max = max;
    }

    @Generated
    public Long getMax() {
        return this.max;
    }

    public static enum Output {
        PATHANDVALUE(false){

            @Override
            void toBuilder(StringBuilder builder, GrepEvent match) {
                builder.append(match.getPath().toString());
                builder.append('=');
                builder.append(match.valueOrNodeAsConciseString());
            }
        }
        ,
        PATHANDFULLVALUE(true){

            @Override
            void toBuilder(StringBuilder builder, GrepEvent match) {
                builder.append(match.getPath().toString());
                builder.append('=');
                builder.append(match.getEvent().valueOrNodeAsString());
            }
        }
        ,
        KEYANDVALUE(false){

            @Override
            void toBuilder(StringBuilder builder, GrepEvent match) {
                builder.append(match.getPath().peekLast());
                builder.append('=');
                builder.append(match.valueOrNodeAsConciseString());
            }
        }
        ,
        KEYANDFULLVALUE(true){

            @Override
            void toBuilder(StringBuilder builder, GrepEvent match) {
                builder.append(match.getPath().peekLast());
                builder.append('=');
                builder.append(match.getEvent().valueOrNodeAsString());
            }
        }
        ,
        PATH(false){

            @Override
            void toBuilder(StringBuilder builder, GrepEvent match) {
                builder.append(match.getPath().toString());
            }
        }
        ,
        KEY(false){

            @Override
            void toBuilder(StringBuilder builder, GrepEvent match) {
                builder.append(match.getPath().peekLast());
            }
        }
        ,
        VALUE(false){

            @Override
            void toBuilder(StringBuilder builder, GrepEvent match) {
                builder.append(match.valueOrNodeAsConciseString());
            }
        }
        ,
        FULLVALUE(true){

            @Override
            void toBuilder(StringBuilder builder, GrepEvent match) {
                builder.append(match.valueOrNodeAsString());
            }
        };

        private final boolean needsObject;

        private Output(boolean needsObject) {
            this.needsObject = needsObject;
        }

        public boolean needsObject() {
            return this.needsObject;
        }

        abstract void toBuilder(StringBuilder var1, GrepEvent var2);
    }
}

