/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep.matching;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Path;
import org.meeuw.json.grep.matching.PathMatcher;

public class PathMatcherOrChain
implements PathMatcher {
    private final PathMatcher[] matchers;

    public PathMatcherOrChain(PathMatcher ... matchers) {
        this.matchers = matchers;
    }

    @Override
    public PathMatcher.MatchResult matches(ParseEvent event) {
        int count = 0;
        for (PathMatcher matcher : this.matchers) {
            ++count;
            PathMatcher.MatchResult matches = matcher.matches(event);
            if (!matches.getAsBoolean()) continue;
            return new PathMatcher.MatchResult(matches.getEvent(), count);
        }
        return new PathMatcher.MatchResult(event, false);
    }

    @Override
    public Predicate<Path> needsKeyCollection() {
        return path -> Arrays.stream(this.matchers).anyMatch(m -> m.needsKeyCollection().test((Path)path));
    }

    @Override
    public Predicate<Path> needsObjectCollection() {
        return path -> Arrays.stream(this.matchers).anyMatch(m -> m.needsObjectCollection().test((Path)path));
    }

    public PathMatcher[] getMatchers() {
        return this.matchers;
    }

    public String toString() {
        return Arrays.stream(this.matchers).map(Object::toString).collect(Collectors.joining(" OR "));
    }
}

