/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep;

import com.fasterxml.jackson.core.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringJoiner;
import lombok.Generated;
import org.meeuw.json.JsonIterator;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.grep.GrepEvent;
import org.meeuw.json.grep.matching.NeverPathMatcher;
import org.meeuw.json.grep.matching.PathMatcher;

public class Grep
implements Iterator<GrepEvent>,
Iterable<GrepEvent> {
    private final PathMatcher matcher;
    private PathMatcher recordMatcher = new NeverPathMatcher();
    final JsonIterator wrapped;
    private final List<GrepEvent> next = new ArrayList<GrepEvent>();

    public Grep(PathMatcher matcher, JsonParser jp) {
        this.matcher = matcher == null ? new NeverPathMatcher() : matcher;
        this.wrapped = new JsonIterator(jp, this.matcher.needsKeyCollection(), this.matcher.needsObjectCollection());
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return !this.next.isEmpty();
    }

    @Override
    public GrepEvent next() {
        this.findNext();
        if (this.next.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.next.remove(0);
    }

    @Override
    public void remove() {
        this.wrapped.remove();
    }

    protected void findNext() {
        if (this.next.isEmpty()) {
            while (this.wrapped.hasNext() && this.next.isEmpty()) {
                ParseEvent event = this.wrapped.next();
                switch (event.getToken()) {
                    case VALUE_STRING: 
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_TRUE: 
                    case VALUE_FALSE: 
                    case VALUE_NULL: 
                    case END_ARRAY: 
                    case END_OBJECT: {
                        PathMatcher.MatchResult result;
                        int recordWeight;
                        if (this.recordMatcher != null && (recordWeight = this.recordMatcher.matches(event).getWeight()) > 0) {
                            this.next.add(new GrepEvent(event, GrepEvent.Type.RECORD, recordWeight));
                        }
                        if ((result = this.matcher.matches(event)).getWeight() <= 0) break;
                        this.next.add(new GrepEvent(result.getEvent(), result.getWeight()));
                    }
                }
            }
        }
    }

    @Override
    public Iterator<GrepEvent> iterator() {
        return this;
    }

    public String toString() {
        return new StringJoiner(", ", Grep.class.getSimpleName() + "[", "]").add("matcher=" + String.valueOf(this.matcher)).add("recordMatcher=" + String.valueOf(this.recordMatcher)).toString();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public PathMatcher getMatcher() {
        return this.matcher;
    }

    @Generated
    public PathMatcher getRecordMatcher() {
        return this.recordMatcher;
    }

    @Generated
    public void setRecordMatcher(PathMatcher recordMatcher) {
        this.recordMatcher = recordMatcher;
    }

    @Generated
    public static class Builder {
        @Generated
        private PathMatcher matcher;
        @Generated
        private JsonParser jp;

        @Generated
        Builder() {
        }

        @Generated
        public Builder matcher(PathMatcher matcher) {
            this.matcher = matcher;
            return this;
        }

        @Generated
        public Builder jp(JsonParser jp) {
            this.jp = jp;
            return this;
        }

        @Generated
        public Grep build() {
            return new Grep(this.matcher, this.jp);
        }

        @Generated
        public String toString() {
            return "Grep.Builder(matcher=" + String.valueOf(this.matcher) + ", jp=" + String.valueOf(this.jp) + ")";
        }
    }
}

